/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.discord.listeners;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import io.github.lightman314.lightmansconsole.LightmansDiscordIntegration;
import io.github.lightman314.lightmansconsole.discord.links.AccountManager;
import io.github.lightman314.lightmansconsole.discord.links.LinkedAccount;
import io.github.lightman314.lightmansconsole.discord.listeners.types.SingleChannelListener;
import io.github.lightman314.lightmansconsole.message.MessageManager;
import io.github.lightman314.lightmansconsole.util.MessageUtil;
import io.github.lightman314.lightmanscurrency.Config;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.universal_traders.TradingOffice;
import io.github.lightman314.lightmanscurrency.common.universal_traders.data.UniversalItemTraderData;
import io.github.lightman314.lightmanscurrency.common.universal_traders.data.UniversalTraderData;
import io.github.lightman314.lightmanscurrency.discord.CurrencyMessages;
import io.github.lightman314.lightmanscurrency.discord.events.DiscordTraderSearchEvent;
import io.github.lightman314.lightmanscurrency.events.AuctionHouseEvent;
import io.github.lightman314.lightmanscurrency.events.NotificationEvent;
import io.github.lightman314.lightmanscurrency.events.UniversalTraderEvent;
import io.github.lightman314.lightmanscurrency.trader.ITrader;
import io.github.lightman314.lightmanscurrency.trader.settings.PlayerReference;
import io.github.lightman314.lightmanscurrency.trader.tradedata.AuctionTradeData;
import io.github.lightman314.lightmanscurrency.trader.tradedata.IBarterTrade;
import io.github.lightman314.lightmanscurrency.trader.tradedata.ItemTradeData;
import io.github.lightman314.lightmanscurrency.trader.tradedata.TradeData;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.dv8tion.jda.api.entities.ChannelType;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.MessageChannel;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CurrencyListener
extends SingleChannelListener {
    private final Timer timer;
    private static final long PENDING_MESSAGE_TIMER = 300000L;
    private static final long ANNOUCEMENT_DELAY = 60000L;
    Map<String, List<String>> pendingMessages = new HashMap<String, List<String>>();

    public CurrencyListener(Supplier<String> consoleChannel) {
        super(consoleChannel, () -> LightmansDiscordIntegration.PROXY.getJDA());
        this.timer = new Timer();
        this.timer.scheduleAtFixedRate((TimerTask)new NotifyTraderOwnerTask(this), 0L, 300000L);
    }

    protected void onChannelMessageReceived(MessageReceivedEvent event) {
        this.handleMessage(event.getChannel(), event.getMessage(), event.getAuthor());
    }

    public void onMessageReceived(MessageReceivedEvent event) {
        if (event.getChannelType() == ChannelType.PRIVATE) {
            this.handleMessage(event.getChannel(), event.getMessage(), event.getAuthor());
        } else {
            super.onMessageReceived(event);
        }
    }

    private void handleMessage(MessageChannel channel, Message message, User author) {
        String prefix;
        if (author.isBot()) {
            return;
        }
        String input = message.getContentDisplay();
        if (input.startsWith(prefix = (String)Config.SERVER.currencyCommandPrefix.get())) {
            String command = input.substring(prefix.length());
            if (command.startsWith("help")) {
                ArrayList<CallSite> output = new ArrayList<CallSite>();
                output.add((CallSite)((Object)(prefix + "notifications <help|enable|disable> - " + CurrencyMessages.M_HELP_LC_NOTIFICATIONS.get())));
                output.add((CallSite)((Object)(prefix + "search <sales|purchases|barters|trades> [searchText] - " + CurrencyMessages.M_HELP_LC_SEARCH1.get())));
                output.add((CallSite)((Object)(prefix + "search <players|shops> [searchText] - " + CurrencyMessages.M_HELP_LC_SEARCH2.get())));
                output.add((CallSite)((Object)(prefix + "search all - " + CurrencyMessages.M_HELP_LC_SEARCH3.get())));
                MessageUtil.sendTextMessage((MessageChannel)channel, output);
            } else if (command.startsWith("notifications ")) {
                String subcommand = command.substring(14);
                if (subcommand.startsWith("help")) {
                    ArrayList<String> output = new ArrayList<String>();
                    if (AccountManager.getLinkedAccountFromUser((User)author) == null) {
                        output.add(CurrencyMessages.M_NOTIFICATIONS_NOTLINKED.get());
                    } else if (AccountManager.currencyNotificationsEnabled((User)author)) {
                        output.add(CurrencyMessages.M_NOTIFICATIONS_ENABLED.get());
                    } else {
                        output.add(CurrencyMessages.M_NOTIFICATIONS_DISABLED.get());
                    }
                    output.addAll(Lists.newArrayList((Object[])CurrencyMessages.M_NOTIFICATIONS_HELP.get().split("\n")));
                    MessageUtil.sendTextMessage((MessageChannel)channel, output);
                } else if (subcommand.startsWith("enable")) {
                    if (AccountManager.getLinkedAccountFromUser((User)author) == null) {
                        MessageUtil.sendTextMessage((MessageChannel)channel, (String)MessageManager.M_ERROR_NOTLINKEDSELF.get());
                    } else if (AccountManager.enableCurrencyNotifications((User)author)) {
                        MessageUtil.sendTextMessage((MessageChannel)channel, (String)CurrencyMessages.M_NOTIFICATIONS_ENABLE_SUCCESS.get());
                    } else {
                        MessageUtil.sendTextMessage((MessageChannel)channel, (String)CurrencyMessages.M_NOTIFICATIONS_ENABLE_FAIL.get());
                    }
                } else if (subcommand.startsWith("disable")) {
                    if (AccountManager.getLinkedAccountFromUser((User)author) == null) {
                        MessageUtil.sendTextMessage((MessageChannel)channel, (String)MessageManager.M_ERROR_NOTLINKEDSELF.get());
                    } else if (AccountManager.disableCurrencyNotifications((User)author)) {
                        MessageUtil.sendTextMessage((MessageChannel)channel, (String)CurrencyMessages.M_NOTIFICATIONS_DISABLE_SUCCESS.get());
                    } else {
                        MessageUtil.sendTextMessage((MessageChannel)channel, (String)CurrencyMessages.M_NOTIFICATIONS_DISABLE_FAIL.get());
                    }
                }
            } else if (command.startsWith("search ")) {
                String subcommand = command.substring(7);
                String text = "";
                SearchCategory type = null;
                if (subcommand.startsWith("sales")) {
                    type = SearchCategory.TRADE_SALE;
                    if (subcommand.length() > 6) {
                        text = subcommand.substring(6).toLowerCase();
                    }
                } else if (subcommand.startsWith("purchases")) {
                    type = SearchCategory.TRADE_PURCHASE;
                    if (subcommand.length() > 10) {
                        text = subcommand.substring(10).toLowerCase();
                    }
                } else if (subcommand.startsWith("barters")) {
                    type = SearchCategory.TRADE_BARTER;
                    if (subcommand.length() > 10) {
                        text = subcommand.substring(10).toLowerCase();
                    }
                } else if (subcommand.startsWith("trades")) {
                    type = SearchCategory.TRADE_ANY;
                    if (subcommand.length() > 7) {
                        text = subcommand.substring(7).toLowerCase();
                    }
                } else if (subcommand.startsWith("players")) {
                    type = SearchCategory.TRADER_OWNER;
                    if (subcommand.length() > 8) {
                        text = subcommand.substring(8).toLowerCase();
                    }
                } else if (subcommand.startsWith("shops")) {
                    type = SearchCategory.TRADER_NAME;
                    if (subcommand.length() > 6) {
                        text = subcommand.substring(6).toLowerCase();
                    }
                } else if (subcommand.startsWith("all")) {
                    type = SearchCategory.TRADER_ANY;
                }
                if (type == null) {
                    MessageUtil.sendTextMessage((MessageChannel)channel, (String)CurrencyMessages.M_SEARCH_BAD_INPUT.get());
                    return;
                }
                SearchCategory searchType = type;
                String searchText = text;
                ArrayList output = new ArrayList();
                TradingOffice.getTraders().forEach(trader -> {
                    try {
                        if (trader instanceof UniversalItemTraderData) {
                            UniversalItemTraderData itemTrader = (UniversalItemTraderData)trader;
                            if (searchType.acceptTrader(itemTrader, searchText)) {
                                boolean showStock = !itemTrader.isCreative();
                                boolean firstTrade = true;
                                for (int i = 0; i < itemTrader.getTradeCount(); ++i) {
                                    String priceText;
                                    String itemName2;
                                    String itemName1;
                                    ItemTradeData trade = itemTrader.getTrade(i);
                                    if (!trade.isValid()) continue;
                                    if (trade.isSale()) {
                                        itemName1 = CurrencyListener.getItemName(trade.getSellItem(0), trade.getCustomName(0));
                                        itemName2 = CurrencyListener.getItemName(trade.getSellItem(1), trade.getCustomName(0));
                                        if (searchType.filterByTrade() && !searchText.isEmpty() && !itemName1.toLowerCase().contains(searchText) && !itemName2.toLowerCase().contains(searchText)) continue;
                                        if (firstTrade) {
                                            output.add("--" + itemTrader.getCoreSettings().getOwnerName() + "'s **" + itemTrader.getName().getString() + "**--");
                                            firstTrade = false;
                                        }
                                        priceText = trade.getCost().getString();
                                        output.add("Selling " + CurrencyListener.getItemNamesAndCount(trade.getSellItem(0), trade.getCustomName(0), trade.getSellItem(1), trade.getCustomName(1)) + " for " + priceText);
                                        if (!showStock) continue;
                                        output.add("*" + trade.stockCount(itemTrader) + " trades in stock.*");
                                        continue;
                                    }
                                    if (trade.isPurchase()) {
                                        itemName1 = CurrencyListener.getItemName(trade.getSellItem(0), "");
                                        itemName2 = CurrencyListener.getItemName(trade.getSellItem(1), "");
                                        if (searchType.filterByTrade() && !searchText.isEmpty() && !itemName1.toLowerCase().contains(searchText) && !itemName2.toLowerCase().contains(searchText)) continue;
                                        if (firstTrade) {
                                            output.add("--" + itemTrader.getCoreSettings().getOwnerName() + "'s **" + itemTrader.getName().getString() + "**--");
                                            firstTrade = false;
                                        }
                                        priceText = trade.getCost().getString();
                                        output.add("Purchasing " + CurrencyListener.getItemNamesAndCount(trade.getSellItem(0), "", trade.getSellItem(1), "") + " for " + priceText);
                                        if (!showStock) continue;
                                        output.add("*" + trade.stockCount(itemTrader) + " trades in stock.*");
                                        continue;
                                    }
                                    if (!trade.isBarter()) continue;
                                    itemName1 = CurrencyListener.getItemName(trade.getSellItem(0), trade.getCustomName(0));
                                    itemName2 = CurrencyListener.getItemName(trade.getSellItem(1), trade.getCustomName(1));
                                    String itemName3 = CurrencyListener.getItemName(trade.getBarterItem(0), "");
                                    String itemName4 = CurrencyListener.getItemName(trade.getBarterItem(1), "");
                                    if (searchType.filterByTrade() && !searchText.isEmpty() && !itemName1.toLowerCase().contains(searchText) && !itemName2.toLowerCase().contains(searchText) && !itemName3.toLowerCase().contains(searchText) && !itemName4.toLowerCase().contains(searchText)) continue;
                                    if (firstTrade) {
                                        output.add("--" + itemTrader.getCoreSettings().getOwnerName() + "'s **" + itemTrader.getName().getString() + "**--");
                                        firstTrade = false;
                                    }
                                    output.add("Bartering " + CurrencyListener.getItemNamesAndCount(trade.getBarterItem(0), "", trade.getBarterItem(1), "") + " for " + CurrencyListener.getItemNamesAndCount(trade.getSellItem(0), trade.getCustomName(0), trade.getSellItem(1), trade.getCustomName(1)));
                                    if (!showStock) continue;
                                    output.add("*" + trade.stockCount(itemTrader) + " trades in stock.*");
                                }
                            }
                        } else {
                            MinecraftForge.EVENT_BUS.post((Event)new DiscordTraderSearchEvent((UniversalTraderData)trader, searchText, searchType, output));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
                if (output.size() > 0) {
                    MessageUtil.sendTextMessage((MessageChannel)channel, output);
                } else {
                    MessageUtil.sendTextMessage((MessageChannel)channel, (String)CurrencyMessages.M_SEARCH_NORESULTS.get());
                }
            }
        }
    }

    private static String getItemName(ItemStack item, String customName) {
        if (item.m_41619_()) {
            return "";
        }
        StringBuffer itemName = new StringBuffer();
        if (customName.isEmpty()) {
            itemName.append(item.m_41786_().getString());
        } else {
            itemName.append("*").append(customName).append("*");
        }
        AtomicBoolean firstEnchantment = new AtomicBoolean(true);
        EnchantmentHelper.m_44831_((ItemStack)item).forEach((enchantment, level) -> {
            if (firstEnchantment.get()) {
                itemName.append(" [").append(enchantment.m_44700_(level.intValue()).getString());
                firstEnchantment.set(false);
            } else {
                itemName.append(", ").append(enchantment.m_44700_(level.intValue()).getString());
            }
        });
        if (!firstEnchantment.get()) {
            itemName.append("]");
        }
        return itemName.toString();
    }

    private static String getItemNamesAndCounts(List<ItemStack> items) {
        ArrayList<CallSite> itemEntries = new ArrayList<CallSite>();
        for (ItemStack item : items) {
            if (item.m_41619_()) continue;
            itemEntries.add((CallSite)((Object)(item.m_41613_() + "x " + CurrencyListener.getItemName(item, ""))));
        }
        if (itemEntries.size() > 0) {
            if (itemEntries.size() == 2) {
                return (String)itemEntries.get(0) + " and " + (String)itemEntries.get(1);
            }
            StringBuffer buffer = new StringBuffer("");
            for (int i = 0; i < itemEntries.size(); ++i) {
                if (i != 0) {
                    buffer.append(", ");
                }
                if (i == itemEntries.size() - 1 && itemEntries.size() > 1) {
                    buffer.append("and ");
                }
                buffer.append((String)itemEntries.get(i));
            }
            return buffer.toString();
        }
        return "NULL";
    }

    private static String getItemNamesAndCount(ItemStack item1, String customName1, ItemStack item2, String customName2) {
        if (item1.m_41619_() && !item2.m_41619_()) {
            return item2.m_41613_() + "x " + CurrencyListener.getItemName(item2, customName2);
        }
        if (item2.m_41619_() && !item1.m_41619_()) {
            return item1.m_41613_() + "x " + CurrencyListener.getItemName(item1, customName1);
        }
        return item1.m_41613_() + "x " + CurrencyListener.getItemName(item1, customName1) + " and " + item2.m_41613_() + "x " + CurrencyListener.getItemName(item2, customName2);
    }

    @SubscribeEvent
    public void onNotification(NotificationEvent.NotificationSent.Post event) {
        try {
            User user;
            LinkedAccount account = AccountManager.getLinkedAccountFromPlayerID((UUID)event.getPlayerID());
            if (account != null && (user = account.getUser()) != null && AccountManager.currencyNotificationsEnabled((User)user)) {
                this.addPendingMessage(user, event.getNotification().getGeneralMessage().getString());
            }
        }
        catch (Exception e) {
            LightmansCurrency.LogError("Error processing notification to bot:", e);
        }
    }

    @SubscribeEvent
    public void onAuctionCreated(AuctionHouseEvent.AuctionEvent.CreateAuctionEvent.Post event) {
        if (!((Boolean)Config.SERVER.auctionHouseCreateNotifications.get()).booleanValue()) {
            return;
        }
        if (event.isPersistent() && !((Boolean)Config.SERVER.auctionHouseCreatePersistentNotifications.get()).booleanValue()) {
            return;
        }
        AuctionTradeData auction = event.getAuction();
        String itemText = CurrencyListener.getItemNamesAndCounts(auction.getAuctionItems());
        String startingBid = auction.getLastBidAmount().getString();
        String minBid = auction.getMinBidDifference().getString();
        if (event.isPersistent()) {
            this.sendTextMessage(CurrencyMessages.M_NEWAUCTION_PERSISTENT.format(new Object[]{itemText, startingBid, minBid}));
        } else {
            PlayerReference owner = auction.getOwner();
            String ownerName = owner != null ? owner.lastKnownName() : "NULL";
            this.sendTextMessage(CurrencyMessages.M_NEWAUCTION.format(new Object[]{ownerName, itemText, startingBid, minBid}));
        }
    }

    @SubscribeEvent
    public void onAuctionCanceled(AuctionHouseEvent.AuctionEvent.CancelAuctionEvent event) {
        if (!((Boolean)Config.SERVER.auctionHouseCancelNotifications.get()).booleanValue()) {
            return;
        }
        this.sendTextMessage(CurrencyMessages.M_CANCELAUCTION.format(new Object[]{event.getPlayer().m_5446_().getString(), CurrencyListener.getItemNamesAndCounts(event.getAuction().getAuctionItems())}));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onAuctionCompleted(AuctionHouseEvent.AuctionEvent.AuctionCompletedEvent event) {
        if (!((Boolean)Config.SERVER.auctionHouseWinNotifications.get()).booleanValue() || !event.hadBidder()) {
            return;
        }
        AuctionTradeData auction = event.getAuction();
        if (auction.getLastBidPlayer() == null) {
            return;
        }
        String winner = auction.getLastBidPlayer().lastKnownName();
        String itemText = CurrencyListener.getItemNamesAndCounts(auction.getAuctionItems());
        String price = auction.getLastBidAmount().getString();
        this.sendTextMessage(CurrencyMessages.M_WINAUCTION.format(new Object[]{winner, itemText, price}));
    }

    public void addPendingMessage(User user, String message) {
        this.addPendingMessage(user, Lists.newArrayList((Object[])new String[]{message}));
    }

    public void addPendingMessage(User user, List<String> messages) {
        String userId = user.getId();
        ArrayList pendingMessages = this.pendingMessages.containsKey(userId) ? this.pendingMessages.get(userId) : Lists.newArrayList();
        messages.forEach(message -> pendingMessages.add(message));
        this.pendingMessages.put(userId, pendingMessages);
    }

    public void sendPendingMessages() {
        this.pendingMessages.forEach((userId, messages) -> {
            try {
                User user = this.getJDA().getUserById(userId);
                if (user != null) {
                    MessageUtil.sendPrivateMessage((User)user, (List)messages);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        this.pendingMessages.clear();
    }

    @SubscribeEvent
    public void onUniversalTraderRegistered(UniversalTraderEvent.UniversalTradeCreateEvent event) {
        if (!((Boolean)Config.SERVER.traderCreationNotifications.get()).booleanValue()) {
            return;
        }
        new Timer().schedule((TimerTask)new AnnouncementTask(this, event), 60000L);
    }

    @SubscribeEvent
    public void onServerStop(ServerStoppingEvent event) {
        this.timer.cancel();
        this.sendPendingMessages();
    }

    private static class NotifyTraderOwnerTask
    extends TimerTask {
        private final CurrencyListener cl;

        public NotifyTraderOwnerTask(CurrencyListener cl) {
            this.cl = cl;
        }

        @Override
        public void run() {
            this.cl.sendPendingMessages();
        }
    }

    public static enum SearchCategory {
        TRADE_SALE(trade -> trade.getTradeDirection() == TradeData.TradeDirection.SALE),
        TRADE_PURCHASE(trade -> trade.getTradeDirection() == TradeData.TradeDirection.PURCHASE),
        TRADE_BARTER(trade -> {
            if (trade instanceof IBarterTrade) {
                return ((IBarterTrade)((Object)trade)).isBarter();
            }
            return false;
        }),
        TRADE_ANY(trade -> true),
        TRADER_OWNER((trader, search) -> search.isEmpty() || trader.getCoreSettings().getOwnerName().toLowerCase().contains((CharSequence)search)),
        TRADER_NAME((trader, search) -> search.isEmpty() || trader.getName().getString().toLowerCase().contains((CharSequence)search)),
        TRADER_ANY((trader, search) -> true);

        private final boolean filterByTrade;
        private final Function<TradeData, Boolean> tradeFilter;
        private final BiFunction<ITrader, String, Boolean> acceptTrader;

        public boolean filterByTrade() {
            return this.filterByTrade;
        }

        public boolean acceptTradeType(TradeData trade) {
            return this.tradeFilter.apply(trade);
        }

        public boolean acceptTrader(ITrader trader, String searchText) {
            return this.acceptTrader.apply(trader, searchText);
        }

        private SearchCategory(Function<TradeData, Boolean> tradeFilter) {
            this.filterByTrade = true;
            this.tradeFilter = tradeFilter;
            this.acceptTrader = (t, s) -> true;
        }

        private SearchCategory(BiFunction<ITrader, String, Boolean> acceptTrader) {
            this.filterByTrade = false;
            this.tradeFilter = t -> true;
            this.acceptTrader = acceptTrader;
        }
    }

    private static class AnnouncementTask
    extends TimerTask {
        private final CurrencyListener cl;
        private final UniversalTraderEvent.UniversalTradeCreateEvent event;

        public AnnouncementTask(CurrencyListener cl, UniversalTraderEvent.UniversalTradeCreateEvent event) {
            this.cl = cl;
            this.event = event;
        }

        @Override
        public void run() {
            try {
                if (this.event.getData() == null) {
                    return;
                }
                if (this.event.getData().getCoreSettings().hasCustomName()) {
                    this.cl.sendTextMessage(CurrencyMessages.M_NEWTRADER_NAMED.format(new Object[]{this.event.getData().getCoreSettings().getOwnerName(), this.event.getData().getCoreSettings().getCustomName()}));
                } else {
                    this.cl.sendTextMessage(CurrencyMessages.M_NEWTRADER.format(new Object[]{this.event.getData().getCoreSettings().getOwnerName()}));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

