/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.menus;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.blockentity.TicketMachineBlockEntity;
import io.github.lightman314.lightmanscurrency.core.ModItems;
import io.github.lightman314.lightmanscurrency.core.ModMenus;
import io.github.lightman314.lightmanscurrency.items.TicketItem;
import io.github.lightman314.lightmanscurrency.menus.slots.OutputSlot;
import io.github.lightman314.lightmanscurrency.menus.slots.ticket.TicketMasterSlot;
import io.github.lightman314.lightmanscurrency.menus.slots.ticket.TicketMaterialSlot;
import java.util.UUID;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class TicketMachineMenu
extends AbstractContainerMenu {
    private final Container output = new SimpleContainer(1);
    private final TicketMachineBlockEntity tileEntity;

    public TicketMachineMenu(int windowId, Inventory inventory, TicketMachineBlockEntity tileEntity) {
        super((MenuType)ModMenus.TICKET_MACHINE.get(), windowId);
        this.tileEntity = tileEntity;
        this.m_38897_(new TicketMasterSlot(this.tileEntity.getStorage(), 0, 20, 21));
        this.m_38897_(new TicketMaterialSlot(this.tileEntity.getStorage(), 1, 56, 21));
        this.m_38897_(new OutputSlot(this.output, 0, 116, 21));
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.m_38897_(new Slot((Container)inventory, x + y * 9 + 9, 8 + x * 18, 56 + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.m_38897_(new Slot((Container)inventory, x, 8 + x * 18, 114));
        }
    }

    public boolean m_6875_(Player playerIn) {
        return true;
    }

    public void m_6877_(Player playerIn) {
        super.m_6877_(playerIn);
        this.m_150411_(playerIn, this.output);
    }

    public ItemStack m_7648_(Player playerEntity, int index) {
        ItemStack clickedStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            clickedStack = slotStack.m_41777_();
            int totalSize = this.tileEntity.getStorage().m_6643_() + this.output.m_6643_();
            if (index < totalSize ? !this.m_38903_(slotStack, totalSize, this.f_38839_.size(), true) : !this.m_38903_(slotStack, 0, this.tileEntity.getStorage().m_6643_(), false)) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return clickedStack;
    }

    public boolean validInputs() {
        return !this.tileEntity.getStorage().m_8020_(1).m_41619_();
    }

    public boolean roomForOutput() {
        ItemStack outputStack = this.output.m_8020_(0);
        if (outputStack.m_41619_()) {
            return true;
        }
        if (this.hasMasterTicket() && outputStack.m_41720_() == ModItems.TICKET.get()) {
            UUID ticketID = this.getTicketID();
            UUID outputTicketID = TicketItem.GetTicketID(outputStack);
            return outputTicketID != null && ticketID.equals(outputTicketID);
        }
        return false;
    }

    public boolean hasMasterTicket() {
        ItemStack masterTicket = this.tileEntity.getStorage().m_8020_(0);
        return !masterTicket.m_41619_() && TicketItem.isMasterTicket(masterTicket);
    }

    public void craftTickets(boolean fullStack) {
        if (!this.validInputs()) {
            LightmansCurrency.LogWarning("Inputs for the Ticket Machine are not valid. Cannot craft tickets.");
            return;
        }
        if (!this.roomForOutput()) {
            LightmansCurrency.LogWarning("No room for Ticket Machine outputs. Cannot craft tickets.");
            return;
        }
        if (this.hasMasterTicket()) {
            ItemStack outputStack;
            int count = 1;
            if (fullStack) {
                count = this.tileEntity.getStorage().m_8020_(1).m_41613_();
            }
            if ((outputStack = this.output.m_8020_(0)).m_41619_()) {
                ItemStack newTicket = TicketItem.CreateTicket(this.getTicketID(), count);
                this.output.m_6836_(0, newTicket);
            } else {
                count = Math.min(count, outputStack.m_41741_() - outputStack.m_41613_());
                outputStack.m_41764_(outputStack.m_41613_() + count);
            }
            this.tileEntity.getStorage().m_7407_(1, count);
        } else {
            ItemStack newTicket = TicketItem.CreateMasterTicket(UUID.randomUUID());
            this.output.m_6836_(0, newTicket);
            this.tileEntity.getStorage().m_7407_(1, 1);
        }
    }

    public UUID getTicketID() {
        ItemStack masterTicket = this.tileEntity.getStorage().m_8020_(0);
        if (TicketItem.isMasterTicket(masterTicket)) {
            return TicketItem.GetTicketID(masterTicket);
        }
        return null;
    }
}

