/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.menus.wallet;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.items.WalletItem;
import io.github.lightman314.lightmanscurrency.menus.slots.CoinSlot;
import io.github.lightman314.lightmanscurrency.menus.slots.DisplaySlot;
import io.github.lightman314.lightmanscurrency.money.MoneyUtil;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public abstract class WalletMenuBase
extends AbstractContainerMenu {
    private static int maxWalletSlots = 0;
    protected final Container dummyInventory = new SimpleContainer(1);
    protected final int walletStackIndex;
    protected final Inventory inventory;
    private boolean autoConvert;
    protected final Container coinInput;
    protected final WalletItem walletItem;
    public final Player player;

    public static int getMaxWalletSlots() {
        return maxWalletSlots;
    }

    public static void updateMaxWalletSlots(int slotCount) {
        maxWalletSlots = Math.max(maxWalletSlots, slotCount);
    }

    public final boolean isEquippedWallet() {
        return this.walletStackIndex < 0;
    }

    public final int getWalletStackIndex() {
        return this.walletStackIndex;
    }

    public final boolean hasWallet() {
        ItemStack wallet = this.getWallet();
        return !wallet.m_41619_() && wallet.m_41720_() instanceof WalletItem;
    }

    public final ItemStack getWallet() {
        if (this.isEquippedWallet()) {
            return LightmansCurrency.getWalletStack(this.inventory.f_35978_);
        }
        return this.inventory.m_8020_(this.walletStackIndex);
    }

    public boolean canConvert() {
        return WalletItem.CanConvert(this.walletItem);
    }

    public boolean canPickup() {
        return WalletItem.CanPickup(this.walletItem);
    }

    public boolean hasBankAccess() {
        return WalletItem.HasBankAccess(this.walletItem);
    }

    public boolean getAutoConvert() {
        return this.autoConvert;
    }

    public void ToggleAutoConvert() {
        this.autoConvert = !this.autoConvert;
        this.saveWalletContents();
    }

    public Player getPlayer() {
        return this.player;
    }

    protected WalletMenuBase(MenuType<?> type, int windowID, Inventory inventory, int walletStackIndex) {
        super(type, windowID);
        this.inventory = inventory;
        this.player = this.inventory.f_35978_;
        this.walletStackIndex = walletStackIndex;
        Item item = this.getWallet().m_41720_();
        this.walletItem = item instanceof WalletItem ? (WalletItem)item : null;
        this.coinInput = new SimpleContainer(WalletItem.InventorySize(this.walletItem));
        this.reloadWalletContents();
        this.autoConvert = WalletItem.getAutoConvert(this.getWallet());
    }

    protected final void addCoinSlots(int yPosition) {
        int y = 0;
        while (y * 9 < this.coinInput.m_6643_()) {
            for (int x = 0; x < 9 && x + y * 9 < this.coinInput.m_6643_(); ++x) {
                this.m_38897_(new CoinSlot(this.coinInput, x + y * 9, 8 + x * 18, yPosition + y * 18).addListener(this::saveWalletContents));
            }
            ++y;
        }
    }

    protected final void addDummySlots(int slotLimit) {
        while (this.f_38839_.size() < slotLimit) {
            this.m_38897_(new DisplaySlot(this.dummyInventory, 0, 0x3FFFFFFF, 0x3FFFFFFF));
        }
    }

    public final void reloadWalletContents() {
        NonNullList<ItemStack> walletInventory = WalletItem.getWalletInventory(this.getWallet());
        for (int i = 0; i < this.coinInput.m_6643_() && i < walletInventory.size(); ++i) {
            this.coinInput.m_6836_(i, (ItemStack)walletInventory.get(i));
        }
    }

    public final int getRowCount() {
        return 1 + (this.coinInput.m_6643_() - 1) / 9;
    }

    public final int getSlotCount() {
        return this.coinInput.m_6643_();
    }

    public boolean m_6875_(Player playerIn) {
        return this.hasWallet();
    }

    public final void saveWalletContents() {
        if (!this.hasWallet()) {
            return;
        }
        NonNullList walletInventory = NonNullList.m_122780_((int)WalletItem.InventorySize(this.walletItem), (Object)ItemStack.f_41583_);
        for (int i = 0; i < walletInventory.size() && i < this.coinInput.m_6643_(); ++i) {
            walletInventory.set(i, (Object)this.coinInput.m_8020_(i));
        }
        WalletItem.putWalletInventory(this.getWallet(), (NonNullList<ItemStack>)walletInventory);
        if (this.autoConvert != WalletItem.getAutoConvert(this.getWallet())) {
            WalletItem.toggleAutoConvert(this.getWallet());
        }
    }

    public final void ConvertCoins() {
        MoneyUtil.ConvertAllCoinsUp(this.coinInput);
        MoneyUtil.SortCoins(this.coinInput);
        this.saveWalletContents();
    }

    public final ItemStack PickupCoins(ItemStack stack) {
        ItemStack returnValue = stack.m_41777_();
        for (int i = 0; i < this.coinInput.m_6643_() && !returnValue.m_41619_(); ++i) {
            ItemStack thisStack = this.coinInput.m_8020_(i);
            if (thisStack.m_41619_()) {
                this.coinInput.m_6836_(i, returnValue.m_41777_());
                returnValue = ItemStack.f_41583_;
                continue;
            }
            if (!InventoryUtil.ItemMatches(thisStack, returnValue)) continue;
            int amountToAdd = MathUtil.clamp(returnValue.m_41613_(), 0, thisStack.m_41741_() - thisStack.m_41613_());
            thisStack.m_41764_(thisStack.m_41613_() + amountToAdd);
            returnValue.m_41764_(returnValue.m_41613_() - amountToAdd);
        }
        if (this.autoConvert) {
            this.ConvertCoins();
        } else {
            this.saveWalletContents();
        }
        return returnValue;
    }
}

