/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.money;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.Config;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.money.MoneyData;
import io.github.lightman314.lightmanscurrency.money.MoneyUtil;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class CoinData {
    public final Item coinItem;
    public final String chain;
    public final Item worthOtherCoin;
    public final int worthOtherCoinCount;
    private final String initialTranslation;
    private final String pluralTranslation;
    public final boolean isHidden;

    private CoinData(Builder builder) {
        this.coinItem = builder.coinItem;
        this.chain = builder.chain;
        this.worthOtherCoin = builder.worthOtherCoin;
        this.worthOtherCoinCount = builder.worthOtherCoinCount;
        this.initialTranslation = builder.initialTranslation;
        this.pluralTranslation = builder.pluralTranslation;
        this.isHidden = builder.isHidden;
    }

    public long getValue() {
        return this.getValue(MoneyUtil.getMoneyData());
    }

    public long getValue(MoneyData moneyData) {
        if (moneyData == null) {
            return 0L;
        }
        if (!this.convertsDownwards()) {
            return 1L;
        }
        CoinData otherCoinData = moneyData.getData(this.worthOtherCoin);
        if (otherCoinData != null) {
            return (long)this.worthOtherCoinCount * otherCoinData.getValue(moneyData);
        }
        LightmansCurrency.LogError("CoinData.getValue() for " + ForgeRegistries.ITEMS.getKey((Object)this.coinItem) + " returning 1 due it's dependent coin (" + ForgeRegistries.ITEMS.getKey((Object)this.worthOtherCoin) + ") not being registered.");
        return 1L;
    }

    public double getDisplayValue() {
        double coreValue = this.getValue();
        double baseValue = MoneyUtil.getValue(Config.getBaseCoinItem());
        return coreValue / baseValue;
    }

    public boolean convertsDownwards() {
        return this.worthOtherCoin != null && this.worthOtherCoinCount > 0;
    }

    public Pair<Item, Integer> getDownwardConversion() {
        return new Pair((Object)this.worthOtherCoin, (Object)this.worthOtherCoinCount);
    }

    public MutableComponent getInitial() {
        if (this.initialTranslation != null && !this.initialTranslation.isBlank()) {
            return Component.m_237115_((String)this.initialTranslation);
        }
        return Component.m_237113_((String)this.coinItem.m_7626_(new ItemStack((ItemLike)this.coinItem)).getString().substring(0, 1).toLowerCase());
    }

    public MutableComponent getPlural() {
        if (this.pluralTranslation != null && !this.pluralTranslation.isBlank()) {
            return Component.m_237115_((String)this.pluralTranslation);
        }
        return MoneyUtil.getDefaultPlural(this.coinItem);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("coinitem", ForgeRegistries.ITEMS.getKey((Object)this.coinItem).toString());
        json.addProperty("chain", this.chain);
        if (this.worthOtherCoin != null && this.worthOtherCoinCount > 0) {
            JsonObject worth = new JsonObject();
            worth.addProperty("coin", ForgeRegistries.ITEMS.getKey((Object)this.worthOtherCoin).toString());
            worth.addProperty("count", (Number)this.worthOtherCoinCount);
            json.add("worth", (JsonElement)worth);
        }
        if (this.initialTranslation != null && !this.initialTranslation.isBlank()) {
            json.addProperty("initial", this.initialTranslation);
        }
        if (this.pluralTranslation != null && !this.pluralTranslation.isBlank()) {
            json.addProperty("plural", this.pluralTranslation);
        }
        if (this.isHidden) {
            json.addProperty("hidden", Boolean.valueOf(true));
        }
        return json;
    }

    public static Builder getBuilder(ItemLike coinItem, String chain) {
        return new Builder(coinItem.m_5456_(), chain);
    }

    public static Builder getBuilder(JsonObject json) {
        Item coinItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(json.get("coinitem").getAsString()));
        String chain = json.get("chain").getAsString();
        Builder builder = new Builder(coinItem, chain);
        if (json.has("worth")) {
            JsonObject worthData = json.get("worth").getAsJsonObject();
            Item otherCoin = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(worthData.get("coin").getAsString()));
            int count = worthData.get("count").getAsInt();
            builder.defineConversion((ItemLike)otherCoin, count);
        }
        if (json.has("initial")) {
            builder.defineInitial(json.get("initial").getAsString());
        }
        if (json.has("plural")) {
            builder.definePluralForm(json.get("plural").getAsString());
        }
        if (json.has("hidden") && json.get("hidden").getAsBoolean()) {
            builder.setHidden();
        }
        return builder;
    }

    public static class Builder {
        final Item coinItem;
        final String chain;
        Item worthOtherCoin = null;
        int worthOtherCoinCount = 0;
        String initialTranslation = "";
        String pluralTranslation = "";
        boolean isHidden = false;

        public Builder(@Nonnull Item coinItem, String chain) {
            this.coinItem = coinItem;
            this.chain = chain;
        }

        public Builder defineConversion(ItemLike otherCoin, int coinAmount) {
            this.worthOtherCoin = otherCoin.m_5456_();
            this.worthOtherCoinCount = coinAmount;
            if (this.worthOtherCoinCount > new ItemStack((ItemLike)this.worthOtherCoin).m_41741_()) {
                this.worthOtherCoinCount = new ItemStack((ItemLike)this.worthOtherCoin).m_41741_();
                LightmansCurrency.LogError("Coin conversion for '" + ForgeRegistries.ITEMS.getKey((Object)this.coinItem).toString() + "' is larger than 1 stack of '" + ForgeRegistries.ITEMS.getKey((Object)this.worthOtherCoin).toString() + "'\nValue will be shrunk to " + this.worthOtherCoinCount);
            }
            return this;
        }

        public Builder defineInitial(String translationString) {
            this.initialTranslation = translationString;
            return this;
        }

        public Builder definePluralForm(String translationString) {
            this.pluralTranslation = translationString;
            return this;
        }

        public Builder setHidden() {
            this.isHidden = true;
            return this;
        }

        public CoinData build() {
            return new CoinData(this);
        }
    }
}

