/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.notifications;

import io.github.lightman314.lightmanscurrency.common.notifications.Notification;
import io.github.lightman314.lightmanscurrency.common.notifications.NotificationData;
import io.github.lightman314.lightmanscurrency.common.universal_traders.TradingOffice;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class MessageFlagNotificationsSeen {
    Notification.Category category;

    public MessageFlagNotificationsSeen(Notification.Category category) {
        this.category = category;
    }

    public static void encode(MessageFlagNotificationsSeen message, FriendlyByteBuf buffer) {
        buffer.m_130079_(message.category.save());
    }

    public static MessageFlagNotificationsSeen decode(FriendlyByteBuf buffer) {
        return new MessageFlagNotificationsSeen(Notification.Category.deserialize(buffer.m_130261_()));
    }

    public static void handle(MessageFlagNotificationsSeen message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            NotificationData data;
            ServerPlayer player = ((NetworkEvent.Context)supplier.get()).getSender();
            if (player != null && (data = TradingOffice.getNotifications((Player)player)) != null && data.unseenNotification(message.category)) {
                for (Notification n : data.getNotifications(message.category)) {
                    if (n.wasSeen()) continue;
                    n.setSeen();
                }
                TradingOffice.MarkNotificationsDirty(player.m_20148_());
            }
        });
        supplier.get().setPacketHandled(true);
    }
}

