/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.persistentdata;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.universal_traders.TradingOffice;
import io.github.lightman314.lightmanscurrency.common.universal_traders.data.UniversalTraderData;
import java.util.ArrayList;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class MessageAddPersistentTrader {
    private static final String GENERATE_ID_FORMAT = "trader_";
    final UUID traderID;
    final String id;
    final String owner;

    public MessageAddPersistentTrader(UUID traderID, String id, String owner) {
        this.traderID = traderID;
        this.id = id;
        this.owner = owner.isBlank() ? "Minecraft" : owner;
    }

    private JsonObject getTraderJson(UniversalTraderData trader, String id) {
        JsonObject traderJson = new JsonObject();
        traderJson.addProperty("id", this.id);
        traderJson.addProperty("OwnerName", this.owner);
        traderJson = trader.saveToJson(traderJson);
        return traderJson;
    }

    public static void encode(MessageAddPersistentTrader message, FriendlyByteBuf buffer) {
        buffer.m_130077_(message.traderID);
        buffer.m_130070_(message.id);
        buffer.m_130070_(message.owner);
    }

    public static MessageAddPersistentTrader decode(FriendlyByteBuf buffer) {
        return new MessageAddPersistentTrader(buffer.m_130259_(), buffer.m_130277_(), buffer.m_130277_());
    }

    public static void handle(MessageAddPersistentTrader message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            UniversalTraderData trader;
            ServerPlayer player = ((NetworkEvent.Context)supplier.get()).getSender();
            if (TradingOffice.isAdminPlayer((Player)player) && (trader = TradingOffice.getData(message.traderID)) != null) {
                int i;
                boolean generateID = message.id.isBlank();
                if (!generateID) {
                    JsonObject traderJson = message.getTraderJson(trader, message.id);
                    JsonArray persistentTraders = TradingOffice.getPersistentTraderJson("Traders");
                    for (int i2 = 0; i2 < persistentTraders.size(); ++i2) {
                        JsonObject traderData = persistentTraders.get(i2).getAsJsonObject();
                        if (!traderData.has("id") || !traderData.get("id").getAsString().equals(message.id)) continue;
                        persistentTraders.set(i2, (JsonElement)traderJson);
                        TradingOffice.setPersistentTraderSection("Traders", persistentTraders);
                        player.m_213846_((Component)Component.m_237110_((String)"lightmanscurrency.message.persistent.trader.overwrite", (Object[])new Object[]{message.id}));
                        return;
                    }
                    persistentTraders.add((JsonElement)traderJson);
                    TradingOffice.setPersistentTraderSection("Traders", persistentTraders);
                    player.m_213846_((Component)Component.m_237110_((String)"lightmanscurrency.message.persistent.trader.add", (Object[])new Object[]{message.id}));
                    return;
                }
                ArrayList<String> knownIDs = new ArrayList<String>();
                JsonArray persistentTraders = TradingOffice.getPersistentTraderJson("Traders");
                for (i = 0; i < persistentTraders.size(); ++i) {
                    JsonObject traderData = persistentTraders.get(i).getAsJsonObject();
                    if (!traderData.has("id")) continue;
                    knownIDs.add(traderData.get("id").getAsString());
                }
                for (i = 1; i < Integer.MAX_VALUE; ++i) {
                    String genID = GENERATE_ID_FORMAT + String.valueOf(i);
                    if (!knownIDs.stream().noneMatch(id -> id.equals(genID))) continue;
                    persistentTraders.add((JsonElement)message.getTraderJson(trader, genID));
                    TradingOffice.setPersistentTraderSection("Traders", persistentTraders);
                    player.m_213846_((Component)Component.m_237110_((String)"lightmanscurrency.message.persistent.trader.add", (Object[])new Object[]{genID}));
                    return;
                }
                LightmansCurrency.LogError("Could not generate ID, as all trader_# ID's are somehow spoken for.");
            }
            player.m_213846_((Component)Component.m_237115_((String)"lightmanscurrency.message.persistent.trader.fail"));
        });
        supplier.get().setPacketHandled(true);
    }
}

