/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.wallet;

import io.github.lightman314.lightmanscurrency.common.capability.IWalletHandler;
import io.github.lightman314.lightmanscurrency.common.capability.WalletCapability;
import io.github.lightman314.lightmanscurrency.items.WalletItem;
import io.github.lightman314.lightmanscurrency.menus.providers.WalletBankMenuProvider;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkHooks;

public class MessageOpenWalletBank {
    private final int walletStackIndex;

    public MessageOpenWalletBank(int walletStackIndex) {
        this.walletStackIndex = walletStackIndex;
    }

    public static void encode(MessageOpenWalletBank message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.walletStackIndex);
    }

    public static MessageOpenWalletBank decode(FriendlyByteBuf buffer) {
        return new MessageOpenWalletBank(buffer.readInt());
    }

    public static void handle(MessageOpenWalletBank message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            IWalletHandler walletHandler;
            ServerPlayer player = ((NetworkEvent.Context)supplier.get()).getSender();
            if (player != null && (walletHandler = (IWalletHandler)WalletCapability.getWalletHandler((Entity)player).orElse(null)) != null && !walletHandler.getWallet().m_41619_()) {
                NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)new WalletBankMenuProvider(message.walletStackIndex), (Consumer)new WalletItem.DataWriter(message.walletStackIndex));
            }
        });
        supplier.get().setPacketHandled(true);
    }
}

