/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.proxy;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.Config;
import io.github.lightman314.lightmanscurrency.CurrencySoundEvents;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.client.ClientTradingOffice;
import io.github.lightman314.lightmanscurrency.client.gui.screen.NotificationScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TeamManagerScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TradeRuleScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TradingTerminalScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.ATMScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.MintScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TicketMachineScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderInterfaceScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderRecoveryScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderStorageScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.WalletBankScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.WalletScreen;
import io.github.lightman314.lightmanscurrency.client.renderer.blockentity.FreezerTraderBlockEntityRenderer;
import io.github.lightman314.lightmanscurrency.client.renderer.blockentity.ItemTraderBlockEntityRenderer;
import io.github.lightman314.lightmanscurrency.client.util.PlayerSuggestionsUtil;
import io.github.lightman314.lightmanscurrency.common.notifications.Notification;
import io.github.lightman314.lightmanscurrency.common.notifications.NotificationData;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.common.universal_traders.TradingOffice;
import io.github.lightman314.lightmanscurrency.common.universal_traders.bank.BankAccount;
import io.github.lightman314.lightmanscurrency.core.ModBlockEntities;
import io.github.lightman314.lightmanscurrency.core.ModBlocks;
import io.github.lightman314.lightmanscurrency.core.ModMenus;
import io.github.lightman314.lightmanscurrency.events.NotificationEvent;
import io.github.lightman314.lightmanscurrency.items.CoinBlockItem;
import io.github.lightman314.lightmanscurrency.items.CoinItem;
import io.github.lightman314.lightmanscurrency.money.CoinData;
import io.github.lightman314.lightmanscurrency.money.MoneyUtil;
import io.github.lightman314.lightmanscurrency.proxy.CommonProxy;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.FreeSample;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.PlayerBlacklist;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.PlayerDiscounts;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.PlayerTradeLimit;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.PlayerWhitelist;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.TimedSale;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.TradeLimit;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.TradeRule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ClientProxy
extends CommonProxy {
    boolean openTerminal = false;
    boolean openTeamManager = false;
    boolean openNotifications = false;
    private long timeOffset = 0L;

    @Override
    public void setupClient() {
        try {
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.DISPLAY_CASE.get()), (RenderType)RenderType.m_110463_());
            this.setRenderLayer(ModBlocks.VENDING_MACHINE.getAll(), RenderType.m_110463_());
            this.setRenderLayer(ModBlocks.VENDING_MACHINE_LARGE.getAll(), RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.ARMOR_DISPLAY.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.GEM_TERMINAL.get()), (RenderType)RenderType.m_110466_());
        }
        catch (Throwable t) {
            LightmansCurrency.LogError("Cannot set block render layers anymore apparently. Hopefully forge has finally made the tutorial on how to define that in the block model...");
        }
        MenuScreens.m_96206_((MenuType)((MenuType)ModMenus.ATM.get()), ATMScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModMenus.MINT.get()), MintScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModMenus.TRADER.get()), TraderScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModMenus.TRADER_UNIVERSAL.get()), TraderScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModMenus.TRADER_STORAGE.get()), TraderStorageScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModMenus.TRADER_STORAGE_UNIVERSAL.get()), TraderStorageScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModMenus.WALLET.get()), WalletScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModMenus.WALLET_BANK.get()), WalletBankScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModMenus.TICKET_MACHINE.get()), TicketMachineScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModMenus.TRADER_INTERFACE.get()), TraderInterfaceScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModMenus.TRADER_RECOVERY.get()), TraderRecoveryScreen::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)ModBlockEntities.ITEM_TRADER.get()), ItemTraderBlockEntityRenderer::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)ModBlockEntities.FREEZER_TRADER.get()), FreezerTraderBlockEntityRenderer::new);
        TradeRuleScreen.RegisterTradeRule((Supplier<TradeRule>)((Supplier)() -> new PlayerWhitelist()));
        TradeRuleScreen.RegisterTradeRule((Supplier<TradeRule>)((Supplier)() -> new PlayerBlacklist()));
        TradeRuleScreen.RegisterTradeRule((Supplier<TradeRule>)((Supplier)() -> new PlayerTradeLimit()));
        TradeRuleScreen.RegisterTradeRule((Supplier<TradeRule>)((Supplier)() -> new PlayerDiscounts()));
        TradeRuleScreen.RegisterTradeRule((Supplier<TradeRule>)((Supplier)() -> new TimedSale()));
        TradeRuleScreen.RegisterTradeRule((Supplier<TradeRule>)((Supplier)() -> new TradeLimit()));
        TradeRuleScreen.RegisterTradeRule((Supplier<TradeRule>)((Supplier)() -> new FreeSample()));
    }

    private void setRenderLayer(List<Block> blocks, RenderType type) {
        for (Block b : blocks) {
            ItemBlockRenderTypes.setRenderLayer((Block)b, (RenderType)type);
        }
    }

    @Override
    public void clearClientTraders() {
        ClientTradingOffice.clearData();
    }

    @Override
    public void updateTrader(CompoundTag compound) {
        ClientTradingOffice.updateTrader(compound);
    }

    @Override
    public void removeTrader(UUID traderID) {
        ClientTradingOffice.removeTrader(traderID);
    }

    @Override
    public void initializeTeams(CompoundTag compound) {
        if (compound.m_128425_("Teams", 9)) {
            ArrayList teams = Lists.newArrayList();
            ListTag teamList = compound.m_128437_("Teams", 10);
            teamList.forEach(nbt -> teams.add(Team.load((CompoundTag)nbt)));
            ClientTradingOffice.initTeams(teams);
        }
    }

    @Override
    public void updateTeam(CompoundTag compound) {
        ClientTradingOffice.updateTeam(compound);
    }

    @Override
    public void removeTeam(UUID teamID) {
        ClientTradingOffice.removeTeam(teamID);
    }

    @Override
    public void initializeBankAccounts(CompoundTag compound) {
        if (compound.m_128425_("BankAccounts", 9)) {
            HashMap<UUID, BankAccount> bank = new HashMap<UUID, BankAccount>();
            ListTag bankList = compound.m_128437_("BankAccounts", 10);
            for (int i = 0; i < bankList.size(); ++i) {
                CompoundTag tag = bankList.m_128728_(i);
                UUID id = tag.m_128342_("Player");
                BankAccount bankAccount = new BankAccount(tag);
                bank.put(id, bankAccount);
            }
            ClientTradingOffice.initBankAccounts(bank);
        }
    }

    @Override
    public void updateBankAccount(CompoundTag compound) {
        ClientTradingOffice.updateBankAccount(compound);
    }

    @Override
    public void receiveEmergencyEjectionData(CompoundTag compound) {
        ClientTradingOffice.updateEjectionData(compound);
    }

    @Override
    public void updateNotifications(NotificationData data) {
        ClientTradingOffice.updateNotifications(data);
    }

    @Override
    public void receiveNotification(Notification notification) {
        Minecraft mc = Minecraft.m_91087_();
        if (MinecraftForge.EVENT_BUS.post((Event)new NotificationEvent.NotificationReceivedOnClient(mc.f_91074_.m_20148_(), ClientTradingOffice.getNotifications(), notification))) {
            return;
        }
        if (((Boolean)Config.CLIENT.pushNotificationsToChat.get()).booleanValue()) {
            mc.f_91065_.m_93076_().m_93785_((Component)notification.getChatMessage());
        }
    }

    @Override
    public void receiveSelectedBankAccount(BankAccount.AccountReference selectedAccount) {
        ClientTradingOffice.updateLastSelectedAccount(selectedAccount);
    }

    @Override
    public void openTerminalScreen() {
        this.openTerminal = true;
    }

    @Override
    public void openNotificationScreen() {
        this.openNotifications = true;
    }

    @Override
    public void openTeamManager() {
        this.openTeamManager = true;
    }

    @Override
    public void createTeamResponse(UUID teamID) {
        Minecraft minecraft = Minecraft.m_91087_();
        Screen openScreen = minecraft.f_91080_;
        if (openScreen instanceof TeamManagerScreen) {
            TeamManagerScreen screen = (TeamManagerScreen)openScreen;
            screen.setActiveTeam(teamID);
        }
    }

    @Override
    public long getTimeDesync() {
        return this.timeOffset;
    }

    @Override
    public void setTimeDesync(long serverTime) {
        this.timeOffset = serverTime - System.currentTimeMillis();
        this.timeOffset = this.timeOffset / 1000L * 1000L;
        if (this.timeOffset < 10000L) {
            this.timeOffset = 0L;
        }
    }

    @Override
    public void loadAdminPlayers(List<UUID> serverAdminList) {
        TradingOffice.loadAdminPlayers(serverAdminList);
    }

    @SubscribeEvent
    public void openScreenOnRenderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            if (this.openTerminal) {
                this.openTerminal = false;
                Minecraft.m_91087_().m_91152_((Screen)new TradingTerminalScreen());
            } else if (this.openTeamManager) {
                this.openTeamManager = false;
                Minecraft.m_91087_().m_91152_((Screen)new TeamManagerScreen());
            } else if (this.openNotifications) {
                this.openNotifications = false;
                Minecraft.m_91087_().m_91152_((Screen)new NotificationScreen());
            }
        }
    }

    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent event) {
        Item item = event.getItemStack().m_41720_();
        CoinData coinData = MoneyUtil.getData(item);
        if (coinData != null && !(item instanceof CoinItem) && !(item instanceof CoinBlockItem)) {
            CoinItem.addCoinTooltips(event.getItemStack(), event.getToolTip());
        }
    }

    @Override
    public void playCoinSound() {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft != null) {
            minecraft.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)CurrencySoundEvents.COINS_CLINKING, (float)1.0f, (float)0.4f));
        }
    }

    @Override
    public void processPlayerList(CompoundTag data) {
        PlayerSuggestionsUtil.loadFromServerData(data);
    }
}

