/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.trader;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.github.lightman314.lightmanscurrency.blockentity.interfaces.IPermissions;
import io.github.lightman314.lightmanscurrency.client.gui.screen.ITradeRuleScreenHandler;
import io.github.lightman314.lightmanscurrency.client.gui.widget.TradeButtonArea;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.TradeButton;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.TraderCategory;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.events.TradeEvent;
import io.github.lightman314.lightmanscurrency.menus.TraderStorageMenu;
import io.github.lightman314.lightmanscurrency.money.CoinValue;
import io.github.lightman314.lightmanscurrency.trader.IDumpable;
import io.github.lightman314.lightmanscurrency.trader.ITraderSource;
import io.github.lightman314.lightmanscurrency.trader.common.InteractionSlotData;
import io.github.lightman314.lightmanscurrency.trader.common.TradeContext;
import io.github.lightman314.lightmanscurrency.trader.settings.CoreTraderSettings;
import io.github.lightman314.lightmanscurrency.trader.settings.PlayerReference;
import io.github.lightman314.lightmanscurrency.trader.settings.Settings;
import io.github.lightman314.lightmanscurrency.trader.tradedata.TradeData;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.ITradeRuleHandler;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public interface ITrader
extends IPermissions,
ITraderSource,
IDumpable {
    public static final int GLOBAL_TRADE_LIMIT = 32;

    @Override
    default public MutableComponent getName() {
        if (this.getCoreSettings().hasCustomName()) {
            return Component.m_237113_((String)this.getCoreSettings().getCustomName());
        }
        return this.getDefaultName();
    }

    default public MutableComponent getTitle() {
        if (this.getCoreSettings().getOwnerName().isBlank()) {
            return this.getName();
        }
        return Component.m_237110_((String)"gui.lightmanscurrency.trading.title", (Object[])new Object[]{this.getName(), this.getCoreSettings().getOwnerName()});
    }

    public MutableComponent getDefaultName();

    public CoinValue getStoredMoney();

    public CoinValue getInternalStoredMoney();

    public void addStoredMoney(CoinValue var1);

    public void removeStoredMoney(CoinValue var1);

    public void clearStoredMoney();

    public void markMoneyDirty();

    public int getTradeCount();

    public void markTradesDirty();

    public int getTradeStock(int var1);

    default public boolean canEditTradeCount() {
        return false;
    }

    default public int getMaxTradeCount() {
        return 4;
    }

    public void openTradeMenu(Player var1);

    public void openStorageMenu(Player var1);

    public CoreTraderSettings getCoreSettings();

    public void markCoreSettingsDirty();

    public List<Settings> getAdditionalSettings();

    default public Map<String, Integer> getAllyDefaultPermissions() {
        return Maps.newHashMap();
    }

    public TraderCategory getNotificationCategory();

    default public boolean isCreative() {
        return this.getCoreSettings().isCreative();
    }

    public void requestAddOrRemoveTrade(boolean var1);

    public void addTrade(Player var1);

    public void removeTrade(Player var1);

    public boolean isClient();

    default public boolean isServer() {
        return !this.isClient();
    }

    default public void userOpen(Player player) {
    }

    default public void userClose(Player player) {
    }

    public void sendOpenTraderMessage();

    public void sendOpenStorageMessage();

    public void sendClearLogMessage();

    @Override
    default public int getPermissionLevel(Player player, String permission) {
        return this.getCoreSettings().getPermissionLevel(player, permission);
    }

    @Override
    default public int getPermissionLevel(PlayerReference player, String permission) {
        return this.getCoreSettings().getPermissionLevel(player, permission);
    }

    public ITradeRuleScreenHandler getRuleScreenHandler(int var1);

    default public TradeEvent.PreTradeEvent runPreTradeEvent(PlayerReference player, TradeData trade) {
        TradeEvent.PreTradeEvent event = new TradeEvent.PreTradeEvent(player, trade, this);
        trade.beforeTrade(event);
        if (this instanceof ITradeRuleHandler) {
            ((ITradeRuleHandler)((Object)this)).beforeTrade(event);
        }
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event;
    }

    default public TradeEvent.TradeCostEvent runTradeCostEvent(PlayerReference player, TradeData trade) {
        TradeEvent.TradeCostEvent event = new TradeEvent.TradeCostEvent(player, trade, this);
        trade.tradeCost(event);
        if (this instanceof ITradeRuleHandler) {
            ((ITradeRuleHandler)((Object)this)).tradeCost(event);
        }
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event;
    }

    default public void runPostTradeEvent(PlayerReference player, TradeData trade, CoinValue pricePaid) {
        TradeEvent.PostTradeEvent event = new TradeEvent.PostTradeEvent(player, trade, this, pricePaid);
        trade.afterTrade(event);
        if (event.isDirty()) {
            this.markTradesDirty();
            event.clean();
        }
        if (this instanceof ITradeRuleHandler) {
            ((ITradeRuleHandler)((Object)this)).afterTrade(event);
            if (event.isDirty()) {
                ((ITradeRuleHandler)((Object)this)).markRulesDirty();
                event.clean();
            }
        }
        MinecraftForge.EVENT_BUS.post((Event)event);
    }

    default public boolean canInteractRemotely() {
        return false;
    }

    public TradeContext.TradeResult ExecuteTrade(TradeContext var1, int var2);

    @Override
    default public List<ITrader> getTraders() {
        return Lists.newArrayList((Object[])new ITrader[]{this});
    }

    @Override
    default public boolean isSingleTrader() {
        return true;
    }

    public List<? extends TradeButton.ITradeData> getTradeInfo();

    default public void addInteractionSlots(List<InteractionSlotData> interactionSlots) {
    }

    default public void initStorageTabs(TraderStorageMenu menu) {
    }

    default public Function<TradeButton.ITradeData, Boolean> getStorageDisplayFilter(TraderStorageMenu menu) {
        return TradeButtonArea.FILTER_ANY;
    }

    @Override
    default public Team getTeam() {
        return this.getCoreSettings().getTeam();
    }

    @Override
    default public PlayerReference getOwner() {
        return this.getCoreSettings().getOwner();
    }
}

