/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.trader.tradedata.rules;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TradeRuleScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollTextDisplay;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.client.util.TextInputUtil;
import io.github.lightman314.lightmanscurrency.events.TradeEvent;
import io.github.lightman314.lightmanscurrency.trader.settings.PlayerReference;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.TradeRule;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PlayerDiscounts
extends TradeRule {
    public static final ResourceLocation TYPE = new ResourceLocation("lightmanscurrency", "discount_list");
    List<PlayerReference> playerList = new ArrayList<PlayerReference>();
    int discount = 10;

    public int getDiscountPercent() {
        return this.discount;
    }

    public void setDiscountPercent(int percent) {
        this.discount = MathUtil.clamp(percent, 0, 100);
    }

    private double getDiscountMult() {
        return 1.0 - (double)this.discount / 100.0;
    }

    private double getIncreaseMult() {
        return 1.0 + (double)this.discount / 100.0;
    }

    public PlayerDiscounts() {
        super(TYPE);
    }

    @Override
    public void beforeTrade(TradeEvent.PreTradeEvent event) {
        if (this.isOnList(event.getPlayerReference())) {
            switch (event.getTrade().getTradeDirection()) {
                case SALE: {
                    event.addHelpful(Component.m_237110_((String)"traderule.lightmanscurrency.discount_list.info.sale", (Object[])new Object[]{this.discount}));
                    break;
                }
                case PURCHASE: {
                    event.addHelpful(Component.m_237110_((String)"traderule.lightmanscurrency.discount_list.info.purchase", (Object[])new Object[]{this.discount}));
                    break;
                }
            }
        }
    }

    @Override
    public void tradeCost(TradeEvent.TradeCostEvent event) {
        if (this.isOnList(event.getPlayerReference())) {
            switch (event.getTrade().getTradeDirection()) {
                case SALE: {
                    event.applyCostMultiplier(this.getDiscountMult());
                    break;
                }
                case PURCHASE: {
                    event.applyCostMultiplier(this.getIncreaseMult());
                    break;
                }
            }
        }
    }

    public boolean isOnList(PlayerReference player) {
        for (int i = 0; i < this.playerList.size(); ++i) {
            if (!this.playerList.get(i).is(player)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected CompoundTag write(CompoundTag compound) {
        ListTag playerNameList = new ListTag();
        for (int i = 0; i < this.playerList.size(); ++i) {
            playerNameList.add((Object)this.playerList.get(i).save());
        }
        compound.m_128365_("Players", (Tag)playerNameList);
        compound.m_128405_("discount", this.discount);
        return compound;
    }

    @Override
    public JsonObject saveToJson(JsonObject json) {
        JsonArray playerList = new JsonArray();
        for (int i = 0; i < this.playerList.size(); ++i) {
            playerList.add((JsonElement)this.playerList.get(i).saveAsJson());
        }
        json.add("Players", (JsonElement)playerList);
        json.addProperty("discounrd", (Number)this.discount);
        return json;
    }

    @Override
    public void readNBT(CompoundTag compound) {
        if (compound.m_128425_("Players", 9)) {
            this.playerList.clear();
            ListTag playerNameList = compound.m_128437_("Players", 10);
            for (int i = 0; i < playerNameList.size(); ++i) {
                CompoundTag thisCompound = playerNameList.m_128728_(i);
                PlayerReference reference = PlayerReference.load(thisCompound);
                if (reference != null) {
                    this.playerList.add(reference);
                    continue;
                }
                if (!thisCompound.m_128425_("name", 8) || (reference = PlayerReference.of(thisCompound.m_128461_("name"))) == null || this.isOnList(reference)) continue;
                this.playerList.add(reference);
            }
        }
        if (compound.m_128425_("discount", 3)) {
            this.discount = compound.m_128451_("discount");
        }
    }

    @Override
    public void loadFromJson(JsonObject json) {
        if (json.has("Players")) {
            this.playerList.clear();
            JsonArray playerList = json.get("Players").getAsJsonArray();
            for (int i = 0; i < playerList.size(); ++i) {
                PlayerReference reference = PlayerReference.load(playerList.get(i));
                if (reference == null || this.isOnList(reference)) continue;
                this.playerList.add(reference);
            }
        }
        if (json.has("discount")) {
            this.discount = json.get("discount").getAsInt();
        }
    }

    @Override
    public void handleUpdateMessage(CompoundTag updateInfo) {
        if (updateInfo.m_128441_("Discount")) {
            this.discount = updateInfo.m_128451_("Discount");
        } else {
            boolean add = updateInfo.m_128471_("Add");
            String name = updateInfo.m_128461_("Name");
            PlayerReference player = PlayerReference.of(name);
            if (add && !this.isOnList(player)) {
                this.playerList.add(player);
            } else if (!add && this.isOnList(player)) {
                PlayerReference.removeFromList(this.playerList, name);
            }
        }
    }

    @Override
    public CompoundTag savePersistentData() {
        return null;
    }

    @Override
    public void loadPersistentData(CompoundTag data) {
    }

    @Override
    public IconData getButtonIcon() {
        return IconAndButtonUtil.ICON_DISCOUNT_LIST;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public TradeRule.GUIHandler createHandler(TradeRuleScreen screen, Supplier<TradeRule> rule) {
        return new GUIHandler(screen, rule);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class GUIHandler
    extends TradeRule.GUIHandler {
        EditBox nameInput;
        EditBox discountInput;
        Button buttonAddPlayer;
        Button buttonRemovePlayer;
        Button buttonSetDiscount;
        ScrollTextDisplay playerList;

        protected final PlayerDiscounts getRule() {
            if (this.getRuleRaw() instanceof PlayerDiscounts) {
                return (PlayerDiscounts)this.getRuleRaw();
            }
            return null;
        }

        GUIHandler(TradeRuleScreen screen, Supplier<TradeRule> rule) {
            super(screen, rule);
        }

        @Override
        public void initTab() {
            Font font = this.screen.getFont();
            int n = this.screen.guiLeft() + 10;
            int n2 = this.screen.guiTop() + 34;
            Objects.requireNonNull(this.screen);
            this.nameInput = this.addCustomRenderable(new EditBox(font, n, n2, 176 - 20, 20, (Component)Component.m_237119_()));
            this.buttonAddPlayer = this.addCustomRenderable(new Button(this.screen.guiLeft() + 10, this.screen.guiTop() + 55, 78, 20, (Component)Component.m_237115_((String)"gui.button.lightmanscurrency.discount.add"), this::PressAddButton));
            int n3 = this.screen.guiLeft();
            Objects.requireNonNull(this.screen);
            this.buttonRemovePlayer = this.addCustomRenderable(new Button(n3 + 176 - 88, this.screen.guiTop() + 55, 78, 20, (Component)Component.m_237115_((String)"gui.button.lightmanscurrency.discount.remove"), this::PressForgetButton));
            this.discountInput = this.addCustomRenderable(new EditBox(this.screen.getFont(), this.screen.guiLeft() + 10, this.screen.guiTop() + 9, 20, 20, (Component)Component.m_237119_()));
            this.discountInput.m_94199_(2);
            this.discountInput.m_94144_(Integer.toString(this.getRule().discount));
            this.buttonSetDiscount = this.addCustomRenderable(new Button(this.screen.guiLeft() + 110, this.screen.guiTop() + 10, 50, 20, (Component)Component.m_237115_((String)"gui.button.lightmanscurrency.discount.set"), this::PressSetDiscountButton));
            int n4 = this.screen.guiLeft() + 7;
            int n5 = this.screen.guiTop() + 78;
            Objects.requireNonNull(this.screen);
            this.playerList = this.addCustomRenderable(new ScrollTextDisplay(n4, n5, 176 - 14, 91, this.screen.getFont(), (Supplier<List<? extends Component>>)((Supplier)this::getPlayerList)));
            this.playerList.setColumnCount(2);
        }

        private List<Component> getPlayerList() {
            ArrayList playerList = Lists.newArrayList();
            if (this.getRule() == null) {
                return playerList;
            }
            for (PlayerReference player : this.getRule().playerList) {
                playerList.add(player.lastKnownNameComponent());
            }
            return playerList;
        }

        @Override
        public void renderTab(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
            if (this.getRule() == null) {
                return;
            }
            int n = this.screen.guiLeft();
            int n2 = this.screen.guiTop() + 78;
            Objects.requireNonNull(this.screen);
            Objects.requireNonNull(this.screen);
            this.screen.m_93228_(poseStack, n, n2, 0, 176, 176, 80);
            int n3 = this.screen.guiLeft();
            int n4 = this.screen.guiTop() + 78 + 80;
            Objects.requireNonNull(this.screen);
            Objects.requireNonNull(this.screen);
            this.screen.m_93228_(poseStack, n3, n4, 0, 176, 176, 11);
            this.screen.getFont().m_92883_(poseStack, Component.m_237115_((String)"gui.lightmanscurrency.discount.tooltip").getString(), (float)(this.discountInput.f_93620_ + this.discountInput.m_5711_() + 4), (float)(this.discountInput.f_93621_ + 3), 0xFFFFFF);
        }

        @Override
        public void onScreenTick() {
            TextInputUtil.whitelistInteger(this.discountInput, 0L, 99L);
        }

        @Override
        public void onTabClose() {
            this.removeCustomWidget(this.nameInput);
            this.removeCustomWidget(this.buttonAddPlayer);
            this.removeCustomWidget(this.buttonRemovePlayer);
            this.removeCustomWidget(this.discountInput);
            this.removeCustomWidget(this.buttonSetDiscount);
            this.removeCustomWidget(this.playerList);
        }

        void PressAddButton(Button button) {
            String name = this.nameInput.m_94155_();
            if (name != "") {
                this.nameInput.m_94144_("");
                PlayerReference reference = PlayerReference.of(name);
                if (reference != null && !this.getRule().isOnList(reference)) {
                    this.getRule().playerList.add(reference);
                }
                CompoundTag updateInfo = new CompoundTag();
                updateInfo.m_128379_("Add", true);
                updateInfo.m_128359_("Name", name);
                this.screen.updateServer(TYPE, updateInfo);
            }
        }

        void PressForgetButton(Button button) {
            String name = this.nameInput.m_94155_();
            if (name != "") {
                this.nameInput.m_94144_("");
                PlayerReference reference = PlayerReference.of(name);
                if (reference != null && this.getRule().isOnList(reference)) {
                    boolean notFound = true;
                    for (int i = 0; notFound && i < this.getRule().playerList.size(); ++i) {
                        if (!this.getRule().playerList.get(i).is(reference)) continue;
                        notFound = false;
                        this.getRule().playerList.remove(i);
                    }
                }
                CompoundTag updateInfo = new CompoundTag();
                updateInfo.m_128379_("Add", false);
                updateInfo.m_128359_("Name", name);
                this.screen.updateServer(TYPE, updateInfo);
            }
        }

        void PressSetDiscountButton(Button button) {
            int discount;
            this.getRule().discount = discount = TextInputUtil.getIntegerValue(this.discountInput, 1);
            CompoundTag updateInfo = new CompoundTag();
            updateInfo.m_128405_("Discount", discount);
            this.screen.updateServer(TYPE, updateInfo);
        }
    }
}

