/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.trader.tradedata.rules;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TradeRuleScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollTextDisplay;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.events.TradeEvent;
import io.github.lightman314.lightmanscurrency.trader.settings.PlayerReference;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.TradeRule;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PlayerWhitelist
extends TradeRule {
    public static final ResourceLocation TYPE = new ResourceLocation("lightmanscurrency", "whitelist");
    List<PlayerReference> whitelistedPlayers = new ArrayList<PlayerReference>();

    public PlayerWhitelist() {
        super(TYPE);
    }

    @Override
    public void beforeTrade(TradeEvent.PreTradeEvent event) {
        if (!this.isWhitelisted(event.getPlayerReference())) {
            event.addDenial(Component.m_237115_((String)"traderule.lightmanscurrency.whitelist.denial"));
        } else {
            event.addHelpful(Component.m_237115_((String)"traderule.lightmanscurrency.whitelist.allowed"));
        }
    }

    public boolean isWhitelisted(PlayerReference player) {
        for (int i = 0; i < this.whitelistedPlayers.size(); ++i) {
            if (!this.whitelistedPlayers.get(i).is(player)) continue;
            return true;
        }
        return false;
    }

    @Override
    public CompoundTag write(CompoundTag compound) {
        ListTag playerNameList = new ListTag();
        for (int i = 0; i < this.whitelistedPlayers.size(); ++i) {
            playerNameList.add((Object)this.whitelistedPlayers.get(i).save());
        }
        compound.m_128365_("WhitelistedPlayers", (Tag)playerNameList);
        return compound;
    }

    @Override
    public JsonObject saveToJson(JsonObject json) {
        JsonArray whitelist = new JsonArray();
        for (int i = 0; i < this.whitelistedPlayers.size(); ++i) {
            whitelist.add((JsonElement)this.whitelistedPlayers.get(i).saveAsJson());
        }
        json.add("WhitelistedPlayers", (JsonElement)whitelist);
        return json;
    }

    @Override
    public void readNBT(CompoundTag compound) {
        int i;
        if (compound.m_128425_("WhitelistedPlayers", 9)) {
            this.whitelistedPlayers.clear();
            ListTag playerList = compound.m_128437_("WhitelistedPlayers", 10);
            for (i = 0; i < playerList.size(); ++i) {
                PlayerReference reference = PlayerReference.load(playerList.m_128728_(i));
                if (reference == null) continue;
                this.whitelistedPlayers.add(reference);
            }
        }
        if (compound.m_128425_("WhitelistedPlayersNames", 9)) {
            this.whitelistedPlayers.clear();
            ListTag playerNameList = compound.m_128437_("WhitelistedPlayersNames", 10);
            for (i = 0; i < playerNameList.size(); ++i) {
                PlayerReference reference;
                CompoundTag thisCompound = playerNameList.m_128728_(i);
                if (!thisCompound.m_128425_("name", 8) || (reference = PlayerReference.of(thisCompound.m_128461_("name"))) == null || this.isWhitelisted(reference)) continue;
                this.whitelistedPlayers.add(reference);
            }
        }
    }

    @Override
    public void loadFromJson(JsonObject json) {
        if (json.has("WhitelistedPlayers")) {
            this.whitelistedPlayers.clear();
            JsonArray whitelist = json.get("WhitelistedPlayers").getAsJsonArray();
            for (int i = 0; i < whitelist.size(); ++i) {
                PlayerReference reference = PlayerReference.load((JsonElement)whitelist.get(i).getAsJsonObject());
                if (reference == null || this.isWhitelisted(reference)) continue;
                this.whitelistedPlayers.add(reference);
            }
        }
    }

    @Override
    public void handleUpdateMessage(CompoundTag updateInfo) {
        boolean add = updateInfo.m_128471_("Add");
        String name = updateInfo.m_128461_("Name");
        PlayerReference player = PlayerReference.of(name);
        if (player == null) {
            return;
        }
        if (add && !this.isWhitelisted(player)) {
            this.whitelistedPlayers.add(player);
        } else if (!add && this.isWhitelisted(player)) {
            PlayerReference.removeFromList(this.whitelistedPlayers, name);
        }
    }

    @Override
    public CompoundTag savePersistentData() {
        return null;
    }

    @Override
    public void loadPersistentData(CompoundTag data) {
    }

    @Override
    public IconData getButtonIcon() {
        return IconAndButtonUtil.ICON_WHITELIST;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public TradeRule.GUIHandler createHandler(TradeRuleScreen screen, Supplier<TradeRule> rule) {
        return new GUIHandler(screen, rule);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class GUIHandler
    extends TradeRule.GUIHandler {
        EditBox nameInput;
        Button buttonAddPlayer;
        Button buttonRemovePlayer;
        ScrollTextDisplay playerDisplay;

        protected final PlayerWhitelist getWhitelistRule() {
            if (this.getRuleRaw() instanceof PlayerWhitelist) {
                return (PlayerWhitelist)this.getRuleRaw();
            }
            return null;
        }

        GUIHandler(TradeRuleScreen screen, Supplier<TradeRule> rule) {
            super(screen, rule);
        }

        @Override
        public void initTab() {
            Font font = this.screen.getFont();
            int n = this.screen.guiLeft() + 10;
            int n2 = this.screen.guiTop() + 9;
            Objects.requireNonNull(this.screen);
            this.nameInput = this.addCustomRenderable(new EditBox(font, n, n2, 176 - 20, 20, (Component)Component.m_237119_()));
            this.buttonAddPlayer = this.screen.addCustomRenderable(new Button(this.screen.guiLeft() + 10, this.screen.guiTop() + 30, 78, 20, (Component)Component.m_237115_((String)"gui.button.lightmanscurrency.whitelist.add"), this::PressWhitelistButton));
            int n3 = this.screen.guiLeft();
            Objects.requireNonNull(this.screen);
            this.buttonRemovePlayer = this.screen.addCustomRenderable(new Button(n3 + 176 - 88, this.screen.guiTop() + 30, 78, 20, (Component)Component.m_237115_((String)"gui.button.lightmanscurrency.whitelist.remove"), this::PressForgetButton));
            int n4 = this.screen.guiLeft() + 7;
            int n5 = this.screen.guiTop() + 55;
            Objects.requireNonNull(this.screen);
            this.playerDisplay = this.screen.addCustomRenderable(new ScrollTextDisplay(n4, n5, 176 - 14, 114, this.screen.getFont(), (Supplier<List<? extends Component>>)((Supplier)this::getWhitelistedPlayers)));
            this.playerDisplay.setColumnCount(2);
        }

        private List<Component> getWhitelistedPlayers() {
            ArrayList playerList = Lists.newArrayList();
            if (this.getWhitelistRule() == null) {
                return playerList;
            }
            for (PlayerReference player : this.getWhitelistRule().whitelistedPlayers) {
                playerList.add(player.lastKnownNameComponent());
            }
            return playerList;
        }

        @Override
        public void renderTab(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        }

        @Override
        public void onTabClose() {
            this.removeCustomWidget(this.nameInput);
            this.removeCustomWidget(this.buttonAddPlayer);
            this.removeCustomWidget(this.buttonRemovePlayer);
            this.removeCustomWidget(this.playerDisplay);
        }

        void PressWhitelistButton(Button button) {
            String name = this.nameInput.m_94155_();
            if (name != "") {
                this.nameInput.m_94144_("");
                PlayerReference reference = PlayerReference.of(name);
                if (reference != null && !this.getWhitelistRule().isWhitelisted(reference)) {
                    this.getWhitelistRule().whitelistedPlayers.add(reference);
                }
                CompoundTag updateInfo = new CompoundTag();
                updateInfo.m_128379_("Add", true);
                updateInfo.m_128359_("Name", name);
                this.screen.updateServer(TYPE, updateInfo);
            }
        }

        void PressForgetButton(Button button) {
            String name = this.nameInput.m_94155_();
            if (name != "") {
                this.nameInput.m_94144_("");
                PlayerReference reference = PlayerReference.of(name);
                if (reference != null && this.getWhitelistRule().isWhitelisted(reference)) {
                    boolean notFound = true;
                    for (int i = 0; notFound && i < this.getWhitelistRule().whitelistedPlayers.size(); ++i) {
                        if (!this.getWhitelistRule().whitelistedPlayers.get(i).is(reference)) continue;
                        notFound = false;
                        this.getWhitelistRule().whitelistedPlayers.remove(i);
                    }
                }
                CompoundTag updateInfo = new CompoundTag();
                updateInfo.m_128379_("Add", false);
                updateInfo.m_128359_("Name", name);
                this.screen.updateServer(TYPE, updateInfo);
            }
        }
    }
}

