/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.trader.tradedata.rules;

import com.google.common.base.Supplier;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TradeRuleScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.TimeWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.client.util.TextInputUtil;
import io.github.lightman314.lightmanscurrency.events.TradeEvent;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.TradeRule;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import io.github.lightman314.lightmanscurrency.util.TimeUtil;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TimedSale
extends TradeRule {
    public static final ResourceLocation TYPE = new ResourceLocation("lightmanscurrency", "timed_sale");
    long startTime = 0L;
    long duration = 0L;
    int discount = 10;

    boolean isActive() {
        return this.startTime != 0L;
    }

    public int getDiscountPercent() {
        return this.discount;
    }

    public void setDiscountPercent(int percent) {
        this.discount = MathUtil.clamp(percent, 0, 100);
    }

    private double getDiscountMult() {
        return 1.0 - (double)this.discount / 100.0;
    }

    private double getIncreaseMult() {
        return 1.0 + (double)this.discount / 100.0;
    }

    public TimedSale() {
        super(TYPE);
    }

    @Override
    public void beforeTrade(TradeEvent.PreTradeEvent event) {
        if (this.isActive() && TimeUtil.compareTime(this.duration, this.startTime)) {
            switch (event.getTrade().getTradeDirection()) {
                case SALE: {
                    event.addHelpful(Component.m_237110_((String)"traderule.lightmanscurrency.timed_sale.info.sale", (Object[])new Object[]{this.discount, this.getTimeRemaining().toString()}));
                    break;
                }
                case PURCHASE: {
                    event.addHelpful(Component.m_237110_((String)"traderule.lightmanscurrency.timed_sale.info.purchase", (Object[])new Object[]{this.discount, this.getTimeRemaining().toString()}));
                    break;
                }
            }
        }
    }

    @Override
    public void tradeCost(TradeEvent.TradeCostEvent event) {
        if (this.isActive() && TimeUtil.compareTime(this.duration, this.startTime)) {
            switch (event.getTrade().getTradeDirection()) {
                case SALE: {
                    event.applyCostMultiplier(this.getDiscountMult());
                    break;
                }
                case PURCHASE: {
                    event.applyCostMultiplier(this.getIncreaseMult());
                    break;
                }
            }
        }
    }

    @Override
    public void afterTrade(TradeEvent.PostTradeEvent event) {
        if (this.confirmStillActive()) {
            event.markDirty();
        }
    }

    private boolean confirmStillActive() {
        if (!this.isActive()) {
            return false;
        }
        if (!TimeUtil.compareTime(this.duration, this.startTime)) {
            this.startTime = 0L;
            return true;
        }
        return false;
    }

    @Override
    protected CompoundTag write(CompoundTag compound) {
        compound.m_128356_("startTime", this.startTime);
        compound.m_128356_("duration", this.duration);
        compound.m_128405_("discount", this.discount);
        return compound;
    }

    @Override
    public JsonObject saveToJson(JsonObject json) {
        json.addProperty("duration", (Number)this.duration);
        json.addProperty("discount", (Number)this.discount);
        return json;
    }

    @Override
    public void readNBT(CompoundTag compound) {
        if (compound.m_128425_("startTime", 4)) {
            this.startTime = compound.m_128454_("startTime");
        }
        if (compound.m_128425_("duration", 4)) {
            this.duration = compound.m_128454_("duration");
        }
        if (compound.m_128425_("discount", 3)) {
            this.discount = compound.m_128451_("discount");
        }
    }

    @Override
    public void loadFromJson(JsonObject json) {
        if (json.has("duration")) {
            this.duration = json.get("duration").getAsLong();
        }
        if (json.has("discount")) {
            this.discount = MathUtil.clamp(this.discount, 0, 100);
        }
    }

    @Override
    public void handleUpdateMessage(CompoundTag updateInfo) {
        if (updateInfo.m_128441_("Discount")) {
            this.discount = updateInfo.m_128451_("Discount");
        } else if (updateInfo.m_128441_("Duration")) {
            this.duration = updateInfo.m_128454_("Duration");
        } else if (updateInfo.m_128441_("StartSale")) {
            if (this.isActive() == updateInfo.m_128471_("StartSale")) {
                return;
            }
            this.startTime = this.isActive() ? 0L : TimeUtil.getCurrentTime();
        }
    }

    @Override
    public CompoundTag savePersistentData() {
        CompoundTag compound = new CompoundTag();
        compound.m_128356_("startTime", this.startTime);
        return compound;
    }

    @Override
    public void loadPersistentData(CompoundTag data) {
        if (data.m_128425_("startTime", 4)) {
            this.startTime = data.m_128454_("startTime");
        }
    }

    public TimeUtil.TimeData getTimeRemaining() {
        if (!this.isActive()) {
            return new TimeUtil.TimeData(0L);
        }
        return new TimeUtil.TimeData(this.startTime + this.duration - TimeUtil.getCurrentTime());
    }

    @Override
    public IconData getButtonIcon() {
        return IconAndButtonUtil.ICON_TIMED_SALE;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public TradeRule.GUIHandler createHandler(TradeRuleScreen screen, Supplier<TradeRule> rule) {
        return new GUIHandler(screen, rule);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class GUIHandler
    extends TradeRule.GUIHandler
    implements TimeWidget.ITimeInput {
        EditBox discountInput;
        Button buttonSetDiscount;
        Button buttonStartSale;
        TimeWidget durationInput;

        protected final TimedSale getRule() {
            if (this.getRuleRaw() instanceof TimedSale) {
                return (TimedSale)this.getRuleRaw();
            }
            return null;
        }

        GUIHandler(TradeRuleScreen screen, Supplier<TradeRule> rule) {
            super(screen, rule);
        }

        @Override
        public void initTab() {
            this.discountInput = this.addCustomRenderable(new EditBox(this.screen.getFont(), this.screen.guiLeft() + 10, this.screen.guiTop() + 9, 20, 20, (Component)Component.m_237119_()));
            this.discountInput.m_94199_(2);
            this.discountInput.m_94144_(Integer.toString(this.getRule().discount));
            this.buttonSetDiscount = this.addCustomRenderable(new Button(this.screen.guiLeft() + 110, this.screen.guiTop() + 10, 50, 20, (Component)Component.m_237115_((String)"gui.button.lightmanscurrency.discount.set"), this::PressSetDiscountButton));
            this.buttonStartSale = this.addCustomRenderable(new Button(this.screen.guiLeft() + 10, this.screen.guiTop() + 45, 156, 20, this.getButtonText(), this::PressStartButton));
            this.durationInput = this.addCustomRenderable(new TimeWidget(this.screen.guiLeft(), this.screen.guiTop() + 75, this.screen.getFont(), this.getRule().duration, this, this, (Component)Component.m_237115_((String)"gui.widget.lightmanscurrency.timed_sale.noduration")));
        }

        @Override
        public void renderTab(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            if (this.getRule() == null) {
                return;
            }
            this.screen.getFont().m_92883_(matrixStack, Component.m_237115_((String)"gui.lightmanscurrency.discount.tooltip").getString(), (float)(this.discountInput.f_93620_ + this.discountInput.m_5711_() + 4), (float)(this.discountInput.f_93621_ + 3), 0xFFFFFF);
            MutableComponent infoText = Component.m_237110_((String)"gui.button.lightmanscurrency.timed_sale.info.inactive", (Object[])new Object[]{new TimeUtil.TimeData(this.getRule().duration).toString()});
            if (this.getRule().isActive()) {
                infoText = Component.m_237110_((String)"gui.button.lightmanscurrency.timed_sale.info.active", (Object[])new Object[]{this.getRule().getTimeRemaining().toString()});
            }
            this.screen.getFont().m_92883_(matrixStack, infoText.getString(), (float)(this.screen.guiLeft() + 10), (float)(this.screen.guiTop() + 35), 0xFFFFFF);
            if (this.buttonStartSale.m_5953_((double)mouseX, (double)mouseY)) {
                this.screen.m_96602_(matrixStack, this.getButtonTooltip(), mouseX, mouseY);
            }
        }

        @Override
        public void onScreenTick() {
            this.buttonStartSale.m_93666_(this.getButtonText());
            this.buttonStartSale.f_93623_ = this.getRule().isActive() || this.getRule().duration > 0L;
            TextInputUtil.whitelistInteger(this.discountInput, 0L, 99L);
        }

        private Component getButtonText() {
            return Component.m_237115_((String)("gui.button.lightmanscurrency.timed_sale." + (this.getRule().isActive() ? "stop" : "start")));
        }

        private Component getButtonTooltip() {
            return Component.m_237115_((String)("gui.button.lightmanscurrency.timed_sale." + (this.getRule().isActive() ? "stop" : "start") + ".tooltip"));
        }

        @Override
        public void onTabClose() {
            this.removeCustomWidget(this.discountInput);
            this.removeCustomWidget(this.buttonSetDiscount);
            this.removeCustomWidget(this.buttonStartSale);
            this.durationInput.getWidgets().forEach(button -> this.removeCustomWidget(button));
            this.removeCustomWidget(this.durationInput);
        }

        void PressSetDiscountButton(Button button) {
            int discount;
            this.getRule().discount = discount = TextInputUtil.getIntegerValue(this.discountInput, 1);
            CompoundTag updateInfo = new CompoundTag();
            updateInfo.m_128405_("Discount", discount);
            this.screen.updateServer(TYPE, updateInfo);
        }

        void PressStartButton(Button button) {
            boolean setActive = !this.getRule().isActive();
            this.getRule().startTime = this.getRule().isActive() ? 0L : TimeUtil.getCurrentTime();
            CompoundTag updateInfo = new CompoundTag();
            updateInfo.m_128379_("StartSale", setActive);
            this.screen.updateServer(TYPE, updateInfo);
        }

        @Override
        public void onTimeSet(long newTime) {
            this.getRule().duration = newTime;
            CompoundTag updateInfo = new CompoundTag();
            updateInfo.m_128356_("Duration", newTime);
            this.screen.updateServer(TYPE, updateInfo);
        }
    }
}

