/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.trader.tradedata.rules;

import com.google.common.base.Supplier;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TradeRuleScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.client.util.TextInputUtil;
import io.github.lightman314.lightmanscurrency.events.TradeEvent;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.TradeRule;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.Objects;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TradeLimit
extends TradeRule {
    public static final ResourceLocation OLD_TYPE = new ResourceLocation("lightmanscurrency", "tradelimit2");
    public static final ResourceLocation TYPE = new ResourceLocation("lightmanscurrency", "trade_limit");
    private int limit = 1;
    int count = 0;

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int newLimit) {
        this.limit = newLimit;
    }

    public void resetCount() {
        this.count = 0;
    }

    public TradeLimit() {
        super(TYPE);
    }

    @Override
    public void beforeTrade(TradeEvent.PreTradeEvent event) {
        if (this.count >= this.limit) {
            event.addDenial(Component.m_237110_((String)"traderule.lightmanscurrency.tradelimit2.denial", (Object[])new Object[]{this.count}));
            event.addDenial(Component.m_237110_((String)"traderule.lightmanscurrency.tradelimit.denial.limit", (Object[])new Object[]{this.limit}));
        } else {
            event.addHelpful(Component.m_237110_((String)"traderule.lightmanscurrency.tradelimit2.info", (Object[])new Object[]{this.count, this.limit}));
        }
    }

    @Override
    public void afterTrade(TradeEvent.PostTradeEvent event) {
        ++this.count;
        event.markDirty();
    }

    @Override
    public CompoundTag write(CompoundTag compound) {
        compound.m_128405_("Limit", this.limit);
        compound.m_128405_("Count", this.count);
        return compound;
    }

    @Override
    public JsonObject saveToJson(JsonObject json) {
        json.addProperty("Limit", (Number)this.limit);
        return json;
    }

    @Override
    public void readNBT(CompoundTag compound) {
        if (compound.m_128425_("Limit", 3)) {
            this.limit = compound.m_128451_("Limit");
        }
        if (compound.m_128425_("Count", 3)) {
            this.count = compound.m_128451_("Count");
        }
    }

    @Override
    public void loadFromJson(JsonObject json) {
        if (json.has("Limit")) {
            this.limit = json.get("Limit").getAsInt();
        }
    }

    @Override
    public void handleUpdateMessage(CompoundTag updateInfo) {
        if (updateInfo.m_128441_("Limit")) {
            this.limit = updateInfo.m_128451_("Limit");
        } else if (updateInfo.m_128441_("ClearMemory")) {
            this.count = 0;
        }
    }

    @Override
    public CompoundTag savePersistentData() {
        CompoundTag data = new CompoundTag();
        data.m_128405_("Count", this.count);
        return data;
    }

    @Override
    public void loadPersistentData(CompoundTag data) {
        if (data.m_128425_("Count", 3)) {
            this.count = data.m_128451_("Count");
        }
    }

    @Override
    public IconData getButtonIcon() {
        return IconAndButtonUtil.ICON_COUNT;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public TradeRule.GUIHandler createHandler(TradeRuleScreen screen, Supplier<TradeRule> rule) {
        return new GUIHandler(screen, rule);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class GUIHandler
    extends TradeRule.GUIHandler {
        EditBox limitInput;
        Button buttonSetLimit;
        Button buttonClearMemory;

        private final TradeLimit getRule() {
            if (this.getRuleRaw() instanceof TradeLimit) {
                return (TradeLimit)this.getRuleRaw();
            }
            return null;
        }

        GUIHandler(TradeRuleScreen screen, Supplier<TradeRule> rule) {
            super(screen, rule);
        }

        @Override
        public void initTab() {
            this.limitInput = this.addCustomRenderable(new EditBox(this.screen.getFont(), this.screen.guiLeft() + 10, this.screen.guiTop() + 19, 30, 20, (Component)Component.m_237119_()));
            this.limitInput.m_94199_(3);
            this.limitInput.m_94144_(Integer.toString(this.getRule().limit));
            this.buttonSetLimit = this.addCustomRenderable(new Button(this.screen.guiLeft() + 41, this.screen.guiTop() + 19, 40, 20, (Component)Component.m_237115_((String)"gui.button.lightmanscurrency.playerlimit.setlimit"), this::PressSetLimitButton));
            int n = this.screen.guiLeft() + 10;
            int n2 = this.screen.guiTop() + 50;
            Objects.requireNonNull(this.screen);
            this.buttonClearMemory = this.addCustomRenderable(new Button(n, n2, 176 - 20, 20, (Component)Component.m_237115_((String)"gui.button.lightmanscurrency.playerlimit.clearmemory"), this::PressClearMemoryButton));
        }

        @Override
        public void renderTab(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
            this.screen.getFont().m_92883_(poseStack, Component.m_237110_((String)"gui.button.lightmanscurrency.playerlimit.info", (Object[])new Object[]{this.getRule().limit}).getString(), (float)(this.screen.guiLeft() + 10), (float)(this.screen.guiTop() + 9), 0xFFFFFF);
            if (this.buttonClearMemory.m_5953_((double)mouseX, (double)mouseY)) {
                this.screen.m_96602_(poseStack, (Component)Component.m_237115_((String)"gui.button.lightmanscurrency.playerlimit.clearmemory.tooltip"), mouseX, mouseY);
            }
        }

        @Override
        public void onTabClose() {
            this.removeCustomWidget(this.limitInput);
            this.removeCustomWidget(this.buttonSetLimit);
            this.removeCustomWidget(this.buttonClearMemory);
        }

        @Override
        public void onScreenTick() {
            TextInputUtil.whitelistInteger(this.limitInput, 1L, 100L);
        }

        void PressSetLimitButton(Button button) {
            int limit;
            this.getRule().limit = limit = MathUtil.clamp(TextInputUtil.getIntegerValue(this.limitInput), 1, 100);
            CompoundTag updateInfo = new CompoundTag();
            updateInfo.m_128405_("Limit", limit);
            this.screen.updateServer(TYPE, updateInfo);
        }

        void PressClearMemoryButton(Button button) {
            this.getRule().resetCount();
            CompoundTag updateInfo = new CompoundTag();
            updateInfo.m_128379_("ClearMemory", true);
            this.screen.updateServer(TYPE, updateInfo);
        }
    }
}

