/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.upgrades;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.github.lightman314.lightmanscurrency.items.UpgradeItem;
import io.github.lightman314.lightmanscurrency.upgrades.ItemCapacityUpgrade;
import io.github.lightman314.lightmanscurrency.upgrades.SpeedUpgrade;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.eventbus.api.Event;

public abstract class UpgradeType {
    private static final Map<ResourceLocation, UpgradeType> UPGRADE_TYPE_REGISTRY = new HashMap<ResourceLocation, UpgradeType>();
    public static final ItemCapacityUpgrade ITEM_CAPACITY = UpgradeType.register(new ResourceLocation("lightmanscurrency", "item_capacity"), new ItemCapacityUpgrade());
    public static final SpeedUpgrade SPEED = UpgradeType.register(new ResourceLocation("lightmanscurrency", "speed"), new SpeedUpgrade());
    private ResourceLocation type;

    protected abstract List<String> getDataTags();

    protected abstract Object defaultTagValue(String var1);

    public List<Component> getTooltip(UpgradeData data) {
        return Lists.newArrayList();
    }

    public final UpgradeData getDefaultData() {
        return new UpgradeData(this);
    }

    public UpgradeType setRegistryName(ResourceLocation name) {
        this.type = name;
        return this;
    }

    public ResourceLocation getRegistryName() {
        return this.type;
    }

    public Class<UpgradeType> getRegistryType() {
        return UpgradeType.class;
    }

    private static final <T extends UpgradeType> T register(ResourceLocation type, T upgradeType) {
        upgradeType.setRegistryName(type);
        UPGRADE_TYPE_REGISTRY.put(type, upgradeType);
        return upgradeType;
    }

    public static class UpgradeData {
        private final Map<String, Object> data = Maps.newHashMap();

        public Set<String> getKeys() {
            return this.data.keySet();
        }

        public boolean hasKey(String tag) {
            return this.getKeys().contains(tag);
        }

        public UpgradeData(UpgradeType upgrade) {
            for (String tag : upgrade.getDataTags()) {
                Object defaultValue = upgrade.defaultTagValue(tag);
                this.data.put(tag, defaultValue);
            }
        }

        public void setValue(String tag, Object value) {
            if (this.data.containsKey(tag)) {
                this.data.put(tag, value);
            }
        }

        public Object getValue(String tag) {
            if (this.data.containsKey(tag)) {
                return this.data.get(tag);
            }
            return null;
        }

        public int getIntValue(String tag) {
            Object value = this.getValue(tag);
            if (value instanceof Integer) {
                return (Integer)value;
            }
            return 0;
        }

        public float getFloatValue(String tag) {
            Object value = this.getValue(tag);
            if (value instanceof Float) {
                return ((Float)value).floatValue();
            }
            return 0.0f;
        }

        public String getStringValue(String tag) {
            Object value = this.getValue(tag);
            if (value instanceof String) {
                return (String)value;
            }
            return "";
        }

        public void read(CompoundTag compound) {
            compound.m_128431_().forEach(key -> {
                if (this.hasKey((String)key)) {
                    if (compound.m_128425_(key, 3)) {
                        this.setValue((String)key, compound.m_128451_(key));
                    } else if (compound.m_128425_(key, 5)) {
                        this.setValue((String)key, Float.valueOf(compound.m_128457_(key)));
                    } else if (compound.m_128425_(key, 8)) {
                        this.setValue((String)key, compound.m_128461_(key));
                    }
                }
            });
        }

        public CompoundTag writeToNBT() {
            return this.writeToNBT(null);
        }

        public CompoundTag writeToNBT(@Nullable UpgradeType source) {
            Map<String, Object> modifiedEntries = source == null ? this.data : UpgradeData.getModifiedEntries(this, source);
            CompoundTag compound = new CompoundTag();
            modifiedEntries.forEach((key, value) -> {
                if (value instanceof Integer) {
                    compound.m_128405_(key, ((Integer)value).intValue());
                } else if (value instanceof Float) {
                    compound.m_128350_(key, ((Float)value).floatValue());
                } else if (value instanceof String) {
                    compound.m_128359_(key, (String)value);
                }
            });
            return compound;
        }

        public static Map<String, Object> getModifiedEntries(UpgradeData queryData, UpgradeType source) {
            HashMap modifiedEntries = Maps.newHashMap();
            source.getDefaultData().data.forEach((key, value) -> {
                if (queryData.data.containsKey(key) && !Objects.equal((Object)queryData.data.get(key), (Object)value)) {
                    modifiedEntries.put(key, value);
                }
            });
            return modifiedEntries;
        }
    }

    public static class RegisterUpgradeTypeEvent
    extends Event {
        public <T extends UpgradeType> void Register(ResourceLocation type, T upgradeType) {
            UpgradeType.register(type, upgradeType);
        }
    }

    public static interface IUpgradeItem {
        public UpgradeType getUpgradeType();

        public UpgradeData getDefaultUpgradeData();

        default public void onApplied(IUpgradeable target) {
        }
    }

    public static interface IUpgradeable {
        default public boolean allowUpgrade(UpgradeItem item) {
            return this.allowUpgrade(item.getUpgradeType());
        }

        public boolean allowUpgrade(UpgradeType var1);
    }
}

