/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class FileUtil {
    public static Gson GSON = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();

    public static JsonObject convertItemStack(ItemStack item) {
        JsonObject json = new JsonObject();
        json.addProperty("id", ForgeRegistries.ITEMS.getKey((Object)item.m_41720_()).toString());
        json.addProperty("Count", (Number)item.m_41613_());
        if (item.m_41782_()) {
            String tag = item.m_41783_().m_7916_();
            json.addProperty("tag", tag);
        }
        return json;
    }

    public static ItemStack parseItemStack(JsonObject json) throws Exception {
        String id = json.get("id").getAsString();
        int count = json.get("Count").getAsInt();
        ItemStack result = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(id)), count);
        try {
            if (json.has("tag")) {
                JsonElement tag = json.get("tag");
                if (tag.isJsonPrimitive() && tag.getAsJsonPrimitive().isString()) {
                    CompoundTag compound = TagParser.m_129359_((String)tag.getAsString());
                    result.m_41751_(compound);
                } else {
                    CompoundTag compound = TagParser.m_129359_((String)GSON.toJson(tag));
                    result.m_41751_(compound);
                }
            }
        }
        catch (Exception e) {
            LightmansCurrency.LogError("Error parsing tag data.", e);
        }
        return result;
    }

    public static void writeStringToFile(File file, String string) throws IOException {
        FileWriter fw = new FileWriter(file);
        BufferedWriter bw = new BufferedWriter(fw);
        PrintWriter writer = new PrintWriter(bw);
        writer.print(string);
        writer.close();
    }
}

