/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.block.dock;

import com.mojang.datafixers.util.Pair;
import dev.murad.shipping.block.IVesselLoader;
import dev.murad.shipping.block.dock.AbstractDockTileEntity;
import dev.murad.shipping.block.dock.BargeDockTileEntity;
import dev.murad.shipping.block.dock.TugDockBlock;
import dev.murad.shipping.entity.custom.VesselEntity;
import dev.murad.shipping.entity.custom.barge.AbstractBargeEntity;
import dev.murad.shipping.entity.custom.tug.AbstractTugEntity;
import dev.murad.shipping.setup.ModTileEntitiesTypes;
import dev.murad.shipping.util.InventoryUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.HopperTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;

public class TugDockTileEntity
extends AbstractDockTileEntity {
    public TugDockTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public TugDockTileEntity() {
        super((TileEntityType)ModTileEntitiesTypes.TUG_DOCK.get());
    }

    private boolean handleItemHopper(VesselEntity tugEntity, HopperTileEntity hopper) {
        if (!(tugEntity instanceof IInventory)) {
            return false;
        }
        return InventoryUtils.mayMoveIntoInventory((IInventory)tugEntity, (IInventory)hopper);
    }

    @Override
    public boolean holdVessel(VesselEntity tug, Direction direction) {
        if (!(tug instanceof AbstractTugEntity) || !((Direction)this.func_195044_w().func_177229_b((Property)TugDockBlock.FACING)).func_176734_d().equals((Object)direction) || tug.func_174811_aO().equals((Object)this.getRowDirection((Direction)this.func_195044_w().func_177229_b((Property)TugDockBlock.FACING)))) {
            return false;
        }
        if (((Boolean)this.func_195044_w().func_177229_b((Property)TugDockBlock.POWERED)).booleanValue()) {
            return true;
        }
        if (this.getHopper().map(hopper -> this.handleItemHopper(tug, (HopperTileEntity)hopper)).orElse(this.getVesselLoader().map(l -> l.holdVessel(tug, IVesselLoader.Mode.EXPORT)).orElse(false)).booleanValue()) {
            return true;
        }
        List<Pair<AbstractBargeEntity, BargeDockTileEntity>> barges = this.getBargeDockPairs((AbstractTugEntity)tug);
        return barges.stream().map(pair -> ((BargeDockTileEntity)((Object)((Object)pair.getSecond()))).holdVessel((VesselEntity)pair.getFirst(), direction)).reduce(false, Boolean::logicalOr) != false;
    }

    @Override
    protected BlockPos getTargetBlockPos() {
        return this.func_174877_v().func_177984_a();
    }

    private List<Pair<AbstractBargeEntity, BargeDockTileEntity>> getBargeDockPairs(AbstractTugEntity tug) {
        List<AbstractBargeEntity> barges = tug.getTrain().getBarges();
        List<BargeDockTileEntity> docks = this.getBargeDocks();
        return IntStream.range(0, Math.min(barges.size(), docks.size())).mapToObj(i -> new Pair(barges.get(i), docks.get(i))).collect(Collectors.toList());
    }

    private List<BargeDockTileEntity> getBargeDocks() {
        Direction facing = (Direction)this.func_195044_w().func_177229_b((Property)TugDockBlock.FACING);
        Direction rowDirection = this.getRowDirection(facing);
        ArrayList<BargeDockTileEntity> docks = new ArrayList<BargeDockTileEntity>();
        Optional<BargeDockTileEntity> dock = this.getNextBargeDock(rowDirection, this.func_174877_v());
        while (dock.isPresent()) {
            docks.add(dock.get());
            dock = this.getNextBargeDock(rowDirection, dock.get().func_174877_v());
        }
        return docks;
    }

    private Direction getRowDirection(Direction facing) {
        return (Boolean)this.func_195044_w().func_177229_b((Property)TugDockBlock.INVERTED) != false ? facing.func_176746_e() : facing.func_176735_f();
    }

    private Optional<BargeDockTileEntity> getNextBargeDock(Direction rowDirection, BlockPos pos) {
        BlockPos next = pos.func_177972_a(rowDirection);
        return Optional.ofNullable(this.field_145850_b.func_175625_s(next)).filter(e -> e instanceof BargeDockTileEntity).map(e -> (BargeDockTileEntity)((Object)e));
    }

    public CompoundNBT func_189515_b(CompoundNBT p_189515_1_) {
        return super.func_189515_b(p_189515_1_);
    }
}

