/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.block.energy;

import dev.murad.shipping.ShippingConfig;
import dev.murad.shipping.block.IVesselLoader;
import dev.murad.shipping.block.energy.VesselChargerBlock;
import dev.murad.shipping.capability.ReadWriteEnergyStorage;
import dev.murad.shipping.entity.custom.VesselEntity;
import dev.murad.shipping.setup.ModTileEntitiesTypes;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class VesselChargerTileEntity
extends TileEntity
implements ITickableTileEntity,
IVesselLoader {
    private static final int MAX_TRANSFER = (Integer)ShippingConfig.Server.VESSEL_CHARGER_BASE_MAX_TRANSFER.get();
    private static final int MAX_CAPACITY = (Integer)ShippingConfig.Server.VESSEL_CHARGER_BASE_CAPACITY.get();
    private final ReadWriteEnergyStorage internalBattery = new ReadWriteEnergyStorage(MAX_CAPACITY, MAX_TRANSFER, MAX_TRANSFER);
    private final LazyOptional<IEnergyStorage> holder = LazyOptional.of(() -> this.internalBattery);
    private int cooldownTime = 0;

    public VesselChargerTileEntity() {
        super((TileEntityType)ModTileEntitiesTypes.VESSEL_CHARGER.get());
        this.internalBattery.setEnergy(0);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return this.holder.cast();
        }
        return super.getCapability(capability, facing);
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            --this.cooldownTime;
            if (this.cooldownTime <= 0) {
                this.cooldownTime = this.tryChargeEntity() ? 0 : 10;
            }
        }
    }

    private boolean tryChargeEntity() {
        return IVesselLoader.getEntityCapability(this.func_174877_v().func_177972_a((Direction)this.func_195044_w().func_177229_b((Property)VesselChargerBlock.FACING)), CapabilityEnergy.ENERGY, this.field_145850_b).map(iEnergyStorage -> {
            int vesselCap = iEnergyStorage.receiveEnergy(MAX_TRANSFER, true);
            int toTransfer = this.internalBattery.extractEnergy(vesselCap, false);
            return iEnergyStorage.receiveEnergy(toTransfer, false) > 0;
        }).orElse(false);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.internalBattery.readAdditionalSaveData(compound.func_74775_l("energy_storage"));
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        CompoundNBT energyNBT = new CompoundNBT();
        this.internalBattery.addAdditionalSaveData(energyNBT);
        CompoundNBT sup = super.func_189515_b(compound);
        sup.func_218657_a("energy_storage", (INBT)energyNBT);
        return sup;
    }

    @Override
    public boolean holdVessel(VesselEntity vessel, IVesselLoader.Mode mode) {
        return vessel.getCapability(CapabilityEnergy.ENERGY).map(energyHandler -> {
            switch (mode) {
                case EXPORT: {
                    return energyHandler.getEnergyStored() < energyHandler.getMaxEnergyStored() - 50 && this.internalBattery.getEnergyStored() > 50;
                }
            }
            return false;
        }).orElse(false);
    }

    public void use(PlayerEntity player, Hand hand) {
        player.func_146105_b((ITextComponent)new TranslationTextComponent("block.littlelogistics.vessel_charger.capacity", new Object[]{this.internalBattery.getEnergyStored(), this.internalBattery.getMaxEnergyStored()}), false);
    }
}

