/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.block.vessel_detector;

import dev.murad.shipping.block.vessel_detector.VesselDetectorBlock;
import dev.murad.shipping.entity.custom.VesselEntity;
import dev.murad.shipping.setup.ModTileEntitiesTypes;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class VesselDetectorTileEntity
extends TileEntity
implements ITickableTileEntity {
    private static final int MAX_RANGE = 3;
    private int cooldown = 0;

    public VesselDetectorTileEntity() {
        super((TileEntityType)ModTileEntitiesTypes.VESSEL_DETECTOR.get());
    }

    private static boolean isValidBlock(BlockState state) {
        return state.func_203425_a(Blocks.field_150355_j) || state.func_203425_a(Blocks.field_150350_a);
    }

    private static int getSearchLimit(BlockPos pos, Direction direction, World level) {
        int i;
        for (i = 0; i < 3 && VesselDetectorTileEntity.isValidBlock(level.func_180495_p(pos)); ++i) {
            pos = pos.func_177972_a(direction);
        }
        return i;
    }

    private void checkForVessel() {
        Direction direction = (Direction)this.func_195044_w().func_177229_b((Property)VesselDetectorBlock.FACING);
        boolean found = !this.field_145850_b.func_175674_a((Entity)null, VesselDetectorTileEntity.getSearchBox(this.func_174877_v(), direction, this.field_145850_b), e -> e instanceof VesselEntity).isEmpty();
        boolean previousPowered = (Boolean)this.func_195044_w().func_177229_b((Property)VesselDetectorBlock.POWERED);
        this.func_195044_w().func_206870_a((Property)VesselDetectorBlock.POWERED, (Comparable)Boolean.valueOf(found));
        this.field_145850_b.func_175656_a(this.func_174877_v(), (BlockState)this.func_195044_w().func_206870_a((Property)VesselDetectorBlock.POWERED, (Comparable)Boolean.valueOf(found)));
        if (found != previousPowered) {
            BlockPos neighbour = this.func_174877_v().func_177972_a(direction.func_176734_d());
            Block block = this.func_195044_w().func_177230_c();
            this.field_145850_b.func_190524_a(neighbour, block, this.func_174877_v());
            this.field_145850_b.func_175695_a(neighbour, block, direction);
        }
    }

    public static AxisAlignedBB getSearchBox(BlockPos pos, Direction direction, World level) {
        int searchLimit = VesselDetectorTileEntity.getSearchLimit(pos.func_177972_a(direction), direction, level);
        Direction.AxisDirection posNeg = direction.func_176743_c();
        BlockPos start = posNeg == Direction.AxisDirection.POSITIVE ? pos.func_177972_a(direction) : pos;
        int offX = direction.func_82601_c() == 0 ? 1 : direction.func_82601_c() * searchLimit;
        int offY = direction.func_96559_d() == 0 ? 1 : direction.func_96559_d() * searchLimit;
        int offZ = direction.func_82599_e() == 0 ? 1 : direction.func_82599_e() * searchLimit;
        BlockPos end = start.func_177982_a(offX, offY, offZ);
        return new AxisAlignedBB(start, end);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.cooldown < 0) {
                this.cooldown = 10;
                this.checkForVessel();
            } else {
                --this.cooldown;
            }
        }
    }
}

