/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.entity.custom.barge;

import com.mojang.datafixers.util.Pair;
import dev.murad.shipping.entity.custom.barge.AbstractBargeEntity;
import dev.murad.shipping.setup.ModEntityTypes;
import dev.murad.shipping.setup.ModItems;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.world.ForgeChunkManager;

public class ChunkLoaderBargeEntity
extends AbstractBargeEntity {
    private Optional<Pair<Integer, Integer>> loadedChunk = Optional.empty();

    public ChunkLoaderBargeEntity(EntityType<? extends ChunkLoaderBargeEntity> type, World world) {
        super((EntityType<? extends AbstractBargeEntity>)type, world);
    }

    public ChunkLoaderBargeEntity(World worldIn, double x, double y, double z) {
        super((EntityType<? extends AbstractBargeEntity>)((EntityType)ModEntityTypes.CHUNK_LOADER_BARGE.get()), worldIn, x, y, z);
    }

    @Override
    public void func_70106_y() {
        super.func_70106_y();
        if (!this.field_70170_p.field_72995_K) {
            this.loadedChunk.ifPresent(c -> this.getSurroundingChunks((Pair<Integer, Integer>)c).forEach(ch -> this.setChunkLoad(false, (Pair<Integer, Integer>)ch)));
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        Pair currChunk = new Pair((Object)this.field_70176_ah, (Object)this.field_70164_aj);
        if (!this.loadedChunk.isPresent()) {
            this.getSurroundingChunks((Pair<Integer, Integer>)currChunk).forEach(c -> this.setChunkLoad(true, (Pair<Integer, Integer>)c));
            this.loadedChunk = Optional.of(currChunk);
        } else if (!currChunk.equals(this.loadedChunk.get())) {
            Set<Pair<Integer, Integer>> needsToBeLoaded = this.getSurroundingChunks((Pair<Integer, Integer>)currChunk);
            Set<Pair<Integer, Integer>> toUnload = this.getSurroundingChunks(this.loadedChunk.get());
            toUnload.removeAll(needsToBeLoaded);
            Set<Pair<Integer, Integer>> prevLoaded = this.getSurroundingChunks(this.loadedChunk.get());
            needsToBeLoaded.removeAll(prevLoaded);
            toUnload.forEach(c -> this.setChunkLoad(false, (Pair<Integer, Integer>)c));
            needsToBeLoaded.forEach(c -> this.setChunkLoad(true, (Pair<Integer, Integer>)c));
            this.loadedChunk = Optional.of(currChunk);
        }
    }

    public void func_213281_b(CompoundNBT p_213281_1_) {
        if (this.loadedChunk.isPresent()) {
            p_213281_1_.func_74768_a("xchunk", ((Integer)this.loadedChunk.get().getFirst()).intValue());
            p_213281_1_.func_74768_a("zchunk", ((Integer)this.loadedChunk.get().getSecond()).intValue());
        }
    }

    @Override
    public void func_70037_a(CompoundNBT p_70037_1_) {
        if (p_70037_1_.func_74764_b("xchunk")) {
            int x = p_70037_1_.func_74762_e("xchunk");
            int z = p_70037_1_.func_74762_e("zchunk");
            this.loadedChunk = Optional.of(new Pair((Object)x, (Object)z));
        }
    }

    private Set<Pair<Integer, Integer>> getSurroundingChunks(Pair<Integer, Integer> chunk) {
        HashSet<Pair<Integer, Integer>> set = new HashSet<Pair<Integer, Integer>>();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                set.add((Pair<Integer, Integer>)new Pair((Object)((Integer)chunk.getFirst() + i), (Object)((Integer)chunk.getSecond() + j)));
            }
        }
        return set;
    }

    private void setChunkLoad(boolean add, Pair<Integer, Integer> chunk) {
        ForgeChunkManager.forceChunk((ServerWorld)((ServerWorld)this.field_70170_p), (String)"littlelogistics", (Entity)this, (int)((Integer)chunk.getFirst()), (int)((Integer)chunk.getSecond()), (boolean)add, (boolean)true);
    }

    @Override
    public Item getDropItem() {
        return (Item)ModItems.CHUNK_LOADER_BARGE.get();
    }

    @Override
    protected void doInteract(PlayerEntity player) {
    }
}

