/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.entity.custom.tug;

import dev.murad.shipping.ShippingConfig;
import dev.murad.shipping.capability.ReadWriteEnergyStorage;
import dev.murad.shipping.entity.accessor.EnergyTugDataAccessor;
import dev.murad.shipping.entity.container.EnergyTugContainer;
import dev.murad.shipping.entity.custom.tug.AbstractTugEntity;
import dev.murad.shipping.setup.ModEntityTypes;
import dev.murad.shipping.setup.ModItems;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyTugEntity
extends AbstractTugEntity {
    private static final int MAX_ENERGY = (Integer)ShippingConfig.Server.ENERGY_TUG_BASE_CAPACITY.get();
    private static final int MAX_TRANSFER = (Integer)ShippingConfig.Server.ENERGY_TUG_BASE_MAX_CHARGE_RATE.get();
    private static final int ENERGY_USAGE = (Integer)ShippingConfig.Server.ENERGY_TUG_BASE_ENERGY_USAGE.get();
    private final ReadWriteEnergyStorage internalBattery = new ReadWriteEnergyStorage(MAX_ENERGY, MAX_TRANSFER, Integer.MAX_VALUE);
    private final LazyOptional<IEnergyStorage> holder = LazyOptional.of(() -> this.internalBattery);

    public EnergyTugEntity(EntityType<? extends WaterMobEntity> type, World world) {
        super(type, world);
        this.internalBattery.setEnergy(0);
    }

    public EnergyTugEntity(World worldIn, double x, double y, double z) {
        super((EntityType)ModEntityTypes.ENERGY_TUG.get(), worldIn, x, y, z);
        this.internalBattery.setEnergy(0);
    }

    @Override
    public Item getDropItem() {
        return (Item)ModItems.ENERGY_TUG.get();
    }

    @Override
    protected int getNonRouteItemSlots() {
        return 1;
    }

    @Override
    protected boolean isTugSlotItemValid(int slot, @Nonnull ItemStack stack) {
        return slot == 1 && stack.getCapability(CapabilityEnergy.ENERGY).isPresent();
    }

    @Override
    protected int getTugSlotLimit(int slot) {
        return 1;
    }

    @Override
    protected INamedContainerProvider createContainerProvider() {
        return new INamedContainerProvider(){

            public ITextComponent func_145748_c_() {
                return new TranslationTextComponent("screen.littlelogistics.energy_tug");
            }

            @Nullable
            public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
                return new EnergyTugContainer(i, EnergyTugEntity.this.field_70170_p, EnergyTugEntity.this.getDataAccessor(), playerInventory, playerEntity);
            }
        };
    }

    @Override
    protected void makeSmoke() {
    }

    @Override
    public boolean allowDockInterface() {
        return true;
    }

    @Override
    public EnergyTugDataAccessor getDataAccessor() {
        return new EnergyTugDataAccessor.Builder(this.func_145782_y()).withEnergy(this.internalBattery::getEnergyStored).withCapacity(this.internalBattery::getMaxEnergyStored).withLit(() -> this.internalBattery.getEnergyStored() > 0).build();
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        this.internalBattery.readAdditionalSaveData(compound.func_74775_l("energy_storage"));
        super.func_70037_a(compound);
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        CompoundNBT energyNBT = new CompoundNBT();
        this.internalBattery.addAdditionalSaveData(energyNBT);
        compound.func_218657_a("energy_storage", (INBT)energyNBT);
        super.func_213281_b(compound);
    }

    @Nullable
    private IEnergyStorage getEnergyCapabilityInSlot(int slot) {
        Optional capabilityOpt;
        LazyOptional capabilityLazyOpt;
        ItemStack stack = this.itemHandler.getStackInSlot(slot);
        if (!stack.func_190926_b() && (capabilityLazyOpt = stack.getCapability(CapabilityEnergy.ENERGY)).isPresent() && (capabilityOpt = capabilityLazyOpt.resolve()).isPresent()) {
            return (IEnergyStorage)capabilityOpt.get();
        }
        return null;
    }

    @Override
    public void func_70071_h_() {
        IEnergyStorage capability;
        if (!this.field_70170_p.field_72995_K && (capability = this.getEnergyCapabilityInSlot(1)) != null) {
            int toExtract = capability.extractEnergy(MAX_TRANSFER, true);
            toExtract = this.internalBattery.receiveEnergy(toExtract, false);
            capability.extractEnergy(toExtract, false);
        }
        super.func_70071_h_();
    }

    @Override
    protected boolean tickFuel() {
        return this.internalBattery.extractEnergy(ENERGY_USAGE, false) > 0;
    }

    public boolean func_191420_l() {
        return false;
    }

    public void func_70299_a(int p_70299_1_, ItemStack p_70299_2_) {
        if (!this.itemHandler.isItemValid(1, p_70299_2_)) {
            return;
        }
        this.itemHandler.insertItem(1, p_70299_2_, false);
        if (!p_70299_2_.func_190926_b() && p_70299_2_.func_190916_E() > this.func_70297_j_()) {
            p_70299_2_.func_190920_e(this.func_70297_j_());
        }
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityEnergy.ENERGY) {
            return this.holder.cast();
        }
        return super.getCapability(cap, side);
    }
}

