/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.entity.custom.tug;

import dev.murad.shipping.ShippingConfig;
import dev.murad.shipping.entity.accessor.SteamTugDataAccessor;
import dev.murad.shipping.entity.container.SteamTugContainer;
import dev.murad.shipping.entity.custom.tug.AbstractTugEntity;
import dev.murad.shipping.setup.ModEntityTypes;
import dev.murad.shipping.setup.ModItems;
import dev.murad.shipping.setup.ModSounds;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.FurnaceTileEntity;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class SteamTugEntity
extends AbstractTugEntity {
    private static final int FURNACE_FUEL_MULTIPLIER = (Integer)ShippingConfig.Server.STEAM_TUG_FUEL_MULTIPLIER.get();
    protected int burnTime = 0;
    protected int burnCapacity = 0;

    public SteamTugEntity(EntityType<? extends WaterMobEntity> type, World world) {
        super(type, world);
    }

    public SteamTugEntity(World worldIn, double x, double y, double z) {
        super((EntityType)ModEntityTypes.STEAM_TUG.get(), worldIn, x, y, z);
    }

    @Override
    protected int getNonRouteItemSlots() {
        return 1;
    }

    @Override
    protected INamedContainerProvider createContainerProvider() {
        return new INamedContainerProvider(){

            public ITextComponent func_145748_c_() {
                return new TranslationTextComponent("screen.littlelogistics.tug");
            }

            @Nullable
            public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
                return new SteamTugContainer(i, SteamTugEntity.this.field_70170_p, SteamTugEntity.this.getDataAccessor(), playerInventory, playerEntity);
            }
        };
    }

    public int getBurnProgress() {
        int i = this.burnCapacity;
        if (i == 0) {
            i = 200;
        }
        return this.burnTime * 13 / i;
    }

    public boolean isLit() {
        return this.burnTime > 0;
    }

    @Override
    public SteamTugDataAccessor getDataAccessor() {
        return new SteamTugDataAccessor.Builder(this.func_145782_y()).withBurnProgress(this::getBurnProgress).withLit(this::isLit).build();
    }

    @Override
    protected boolean isTugSlotItemValid(int slot, @Nonnull ItemStack stack) {
        return slot == 1 && FurnaceTileEntity.func_213991_b((ItemStack)stack);
    }

    @Override
    protected int getTugSlotLimit(int slot) {
        return slot == 1 ? 64 : 0;
    }

    @Override
    protected boolean tickFuel() {
        if (this.burnTime > 0) {
            --this.burnTime;
            return true;
        }
        ItemStack stack = this.itemHandler.getStackInSlot(1);
        if (!stack.func_190926_b()) {
            this.burnCapacity = ForgeHooks.getBurnTime((ItemStack)stack, null) * FURNACE_FUEL_MULTIPLIER - 1;
            this.burnTime = this.burnCapacity - 1;
            stack.func_190918_g(1);
            return true;
        }
        this.burnCapacity = 0;
        this.burnTime = 0;
        return false;
    }

    @Override
    public Item getDropItem() {
        return (Item)ModItems.STEAM_TUG.get();
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        this.burnTime = compound.func_74764_b("burn") ? compound.func_74762_e("burn") : 0;
        this.burnCapacity = compound.func_74764_b("burn_capacity") ? compound.func_74762_e("burn_capacity") : 0;
        super.func_70037_a(compound);
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        compound.func_74768_a("burn", this.burnTime);
        compound.func_74768_a("burn_capacity", this.burnCapacity);
        super.func_213281_b(compound);
    }

    @Override
    protected void onUndock() {
        super.onUndock();
        this.func_184185_a((SoundEvent)ModSounds.STEAM_TUG_WHISTLE.get(), 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
    }

    public boolean func_191420_l() {
        return this.itemHandler.getStackInSlot(1).func_190926_b();
    }

    public void func_70299_a(int p_70299_1_, ItemStack p_70299_2_) {
        if (!this.itemHandler.isItemValid(1, p_70299_2_)) {
            return;
        }
        this.itemHandler.insertItem(1, p_70299_2_, false);
        if (!p_70299_2_.func_190926_b() && p_70299_2_.func_190916_E() > this.func_70297_j_()) {
            p_70299_2_.func_190920_e(this.func_70297_j_());
        }
    }
}

