/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.item.container;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.datafixers.util.Pair;
import dev.murad.shipping.item.container.TugRouteScreen;
import dev.murad.shipping.network.SetTag;
import dev.murad.shipping.network.TugRoutePacketHandler;
import dev.murad.shipping.util.TugRoute;
import dev.murad.shipping.util.TugRouteNode;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.ExtendedList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TugRouteClientHandler {
    private static final Logger LOGGER = LogManager.getLogger(TugRouteClientHandler.class);
    private TugList widget;
    private TugRoute route;
    private boolean isOffHand;
    private Minecraft minecraft;
    private TugRouteScreen screen;

    public TugRouteClientHandler(TugRouteScreen screen, Minecraft minecraft, TugRoute route, boolean isOffHand) {
        this.route = route;
        this.isOffHand = isOffHand;
        this.screen = screen;
        this.minecraft = minecraft;
    }

    public TugList initializeWidget(int width, int height, int y0, int y1, int itemHeight) {
        this.widget = new TugList(this.minecraft, width, height, y0, y1, itemHeight);
        for (int i = 0; i < this.route.size(); ++i) {
            this.widget.add((TugRouteNode)this.route.get(i), i);
        }
        return this.widget;
    }

    public void deleteSelected() {
        TugList.Entry selected = (TugList.Entry)this.widget.func_230958_g_();
        if (selected != null) {
            int index = selected.index;
            this.route.remove(index);
            this.widget.func_231039_at__().remove(index);
            this.widget.func_241215_a_(null);
            this.markDirty();
        }
    }

    public void moveSelectedUp() {
        int index;
        TugList.Entry selected = (TugList.Entry)this.widget.func_230958_g_();
        if (selected != null && (index = selected.index) > 0) {
            TugRouteNode node = (TugRouteNode)this.route.remove(selected.index);
            this.widget.func_231039_at__().remove(index);
            this.route.add(index - 1, node);
            this.widget.func_231039_at__().add(index - 1, selected);
            this.markDirty();
        }
    }

    public void moveSelectedDown() {
        int index;
        TugList.Entry selected = (TugList.Entry)this.widget.func_230958_g_();
        if (selected != null && (index = selected.index) < this.route.size() - 1) {
            TugRouteNode node = (TugRouteNode)this.route.remove(selected.index);
            this.widget.func_231039_at__().remove(index);
            this.route.add(index + 1, node);
            this.widget.func_231039_at__().add(index + 1, selected);
            this.markDirty();
        }
    }

    public void renameSelected(@Nullable String name) {
        TugList.Entry selected = (TugList.Entry)this.widget.func_230958_g_();
        if (selected != null) {
            int index = selected.index;
            ((TugRouteNode)this.route.get(index)).setName(name);
            this.markDirty();
        }
    }

    public Optional<Pair<Integer, TugRouteNode>> getSelected() {
        TugList.Entry selected = (TugList.Entry)this.widget.func_230958_g_();
        if (selected != null) {
            int index = selected.index;
            return Optional.of(new Pair((Object)index, this.route.get(index)));
        }
        return Optional.empty();
    }

    public void render(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        this.widget.func_230430_a_(stack, mouseX, mouseY, partialTicks);
    }

    private void markDirty() {
        int i = 0;
        for (TugList.Entry entry : this.widget.func_231039_at__()) {
            entry.setIndex(i++);
        }
        TugRoutePacketHandler.INSTANCE.sendToServer((Object)new SetTag(this.route.hashCode(), this.isOffHand, this.route.toNBT()));
    }

    public final class TugList
    extends ExtendedList<Entry> {
        public TugList(Minecraft minecraft, int width, int height, int y0, int y1, int itemHeight) {
            super(minecraft, width, height, y0, y1, itemHeight);
            this.func_244605_b(false);
            this.func_244606_c(false);
        }

        public Optional<IGuiEventListener> func_212930_a(double p_212930_1_, double p_212930_3_) {
            return super.func_212930_a(p_212930_1_, p_212930_3_);
        }

        public void func_230430_a_(MatrixStack p_230430_1_, int p_230430_2_, int p_230430_3_, float p_230430_4_) {
            super.func_230430_a_(p_230430_1_, p_230430_2_, p_230430_3_, p_230430_4_);
        }

        public void add(TugRouteNode node, int index) {
            this.func_230513_b_((AbstractList.AbstractListEntry)new Entry(node, index));
        }

        public int func_230949_c_() {
            return TugRouteClientHandler.this.screen.getXSize() - 40;
        }

        protected int func_230952_d_() {
            return (this.field_230670_d_ + this.func_230949_c_()) / 2 + 5;
        }

        public class Entry
        extends ExtendedList.AbstractListEntry<Entry> {
            private TugRouteNode node;
            private int index;

            public Entry(TugRouteNode node, int index) {
                this.node = node;
                this.index = index;
            }

            public void func_230432_a_(MatrixStack matrixStack, int ind, int rowTop, int rowLeft, int width, int height, int mouseX, int mouseY, boolean hovered, float partialTicks) {
                String s = this.node.getDisplayName(this.index) + ": " + this.node.getDisplayCoords();
                TugRouteClientHandler.this.screen.getMinecraft().func_110434_K().func_110577_a(TugRouteScreen.GUI);
                TugList.this.func_238474_b_(matrixStack, rowLeft, rowTop, 0, hovered ? 216 : 236, width - 3, height);
                TugRouteClientHandler.this.screen.getFont().func_238421_b_(matrixStack, s, (float)(rowLeft + 3), (float)(rowTop + 4), 0xFFFFFF);
            }

            public void setIndex(int index) {
                this.index = index;
            }

            public boolean func_231044_a_(double mouseX, double mouseY, int button) {
                if (button == 0) {
                    this.select();
                    return true;
                }
                return false;
            }

            private void select() {
                TugList.this.func_241215_a_((AbstractList.AbstractListEntry)this);
            }
        }
    }
}

