/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.item.container;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import dev.murad.shipping.item.TugRouteItem;
import dev.murad.shipping.item.container.StringInputScreen;
import dev.murad.shipping.item.container.TugRouteClientHandler;
import dev.murad.shipping.item.container.TugRouteContainer;
import dev.murad.shipping.util.TugRouteNode;
import java.util.Optional;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TugRouteScreen
extends ContainerScreen<TugRouteContainer> {
    private static final Logger LOGGER = LogManager.getLogger(TugRouteScreen.class);
    public static final ResourceLocation GUI = new ResourceLocation("littlelogistics", "textures/container/tug_route.png");
    private final ItemStack stack;
    private final TugRouteClientHandler route;

    public TugRouteScreen(TugRouteContainer menu, PlayerInventory inventory, ITextComponent title) {
        super((Container)menu, inventory, title);
        this.field_146999_f = 256;
        this.field_147000_g = 233;
        this.stack = ((TugRouteContainer)this.field_147002_h).getItemStack();
        this.route = new TugRouteClientHandler(this, this.field_230706_i_, TugRouteItem.getRoute(this.stack), menu.isOffHand());
    }

    private int getRight() {
        return this.field_147003_i + this.field_146999_f;
    }

    private int getBot() {
        return this.field_147009_r + this.field_147000_g;
    }

    private Button.ITooltip getTooltip(ITextComponent tooltip) {
        return (button, stack, x, y) -> this.func_238652_a_(stack, tooltip, x, y);
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        LOGGER.info("Initializing TugRouteScreen");
        this.func_230481_d_((IGuiEventListener)this.route.initializeWidget(this.field_230708_k_, this.field_230709_l_, this.field_147009_r + 40, this.field_147009_r + this.field_147000_g - 45, 20));
        this.func_230480_a_((Widget)new Button(this.getRight() - 92, this.getBot() - 24, 20, 20, (ITextComponent)new StringTextComponent("..\ua56f").func_240699_a_(TextFormatting.BOLD), button -> {
            Optional<Pair<Integer, TugRouteNode>> selectedOpt = this.route.getSelected();
            if (selectedOpt.isPresent()) {
                Pair<Integer, TugRouteNode> selected = selectedOpt.get();
                this.field_230706_i_.pushGuiLayer((Screen)new StringInputScreen((TugRouteNode)selected.getSecond(), (Integer)selected.getFirst(), this.route::renameSelected));
            }
        }, this.getTooltip((ITextComponent)new TranslationTextComponent("screen.littlelogistics.tug_route.rename_button"))));
        this.func_230480_a_((Widget)new Button(this.getRight() - 70, this.getBot() - 24, 20, 20, (ITextComponent)new StringTextComponent("\u25b2"), button -> this.route.moveSelectedUp(), this.getTooltip((ITextComponent)new TranslationTextComponent("screen.littlelogistics.tug_route.up_button"))));
        this.func_230480_a_((Widget)new Button(this.getRight() - 47, this.getBot() - 24, 20, 20, (ITextComponent)new StringTextComponent("\u25bc"), button -> this.route.moveSelectedDown(), this.getTooltip((ITextComponent)new TranslationTextComponent("screen.littlelogistics.tug_route.down_button"))));
        this.func_230480_a_((Widget)new Button(this.getRight() - 24, this.getBot() - 24, 20, 20, (ITextComponent)new StringTextComponent("\u2718"), button -> this.route.deleteSelected(), this.getTooltip((ITextComponent)new TranslationTextComponent("screen.littlelogistics.tug_route.delete_button"))));
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.func_230459_a_(matrixStack, mouseX, mouseY);
        this.route.render(matrixStack, mouseX, mouseY, partialTicks);
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int x, int y) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(GUI);
        int left = this.getGuiLeft();
        int top = this.getGuiTop();
        int right = this.getRight();
        int bot = this.getBot();
        this.func_238474_b_(matrixStack, left, top, 0, 0, 4, 4);
        this.func_238474_b_(matrixStack, this.getRight() - 4, top, 8, 0, 4, 4);
        this.func_238474_b_(matrixStack, left, this.getBot() - 4, 0, 8, 4, 4);
        this.func_238474_b_(matrixStack, this.getRight() - 4, this.getBot() - 4, 8, 8, 4, 4);
        int zoom = 1000;
        this.correctBlit(matrixStack, left + 4, top, this.func_230927_p_(), 4 * zoom, 0.0f, this.getXSize() - 8, 4, 256 * zoom, 256);
        this.correctBlit(matrixStack, left + 4, bot - 4, this.func_230927_p_(), 4 * zoom, 8.0f, this.getXSize() - 8, 4, 256 * zoom, 256);
        this.correctBlit(matrixStack, left, top + 4, this.func_230927_p_(), 0.0f, 4 * zoom, 4, this.getYSize() - 8, 256, 256 * zoom);
        this.correctBlit(matrixStack, right - 4, top + 4, this.func_230927_p_(), 8.0f, 4 * zoom, 4, this.getYSize() - 8, 256, 256 * zoom);
        this.correctBlit(matrixStack, left + 4, top + 4, this.func_230927_p_(), 4 * zoom, 4 * zoom, this.getXSize() - 8, this.getYSize() - 8, 256 * zoom, 256 * zoom);
    }

    private void correctBlit(MatrixStack stack, int x, int y, int z, float u, float v, int w, int h, int texW, int texH) {
        TugRouteScreen.func_238464_a_((MatrixStack)stack, (int)x, (int)y, (int)z, (float)u, (float)v, (int)w, (int)h, (int)texH, (int)texW);
    }

    protected void func_230451_b_(MatrixStack stack, int p_230451_2_, int p_230451_3_) {
        this.field_230712_o_.func_243248_b(stack, this.field_230704_d_, (float)this.field_238742_p_, (float)this.field_238743_q_, 0x404040);
    }

    public FontRenderer getFont() {
        return this.field_230712_o_;
    }
}

