/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.item.creative;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class CreativeCapacitor
extends Item {
    public CreativeCapacitor(Item.Properties props) {
        super(props);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new ICapabilityProvider(){

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                if (cap == CapabilityEnergy.ENERGY) {
                    return LazyOptional.of(CreativeEnergyStorage::new).cast();
                }
                return LazyOptional.empty();
            }
        };
    }

    static class CreativeEnergyStorage
    implements IEnergyStorage {
        CreativeEnergyStorage() {
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return maxReceive;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return maxExtract;
        }

        public int getEnergyStored() {
            return Integer.MAX_VALUE;
        }

        public int getMaxEnergyStored() {
            return Integer.MAX_VALUE;
        }

        public boolean canExtract() {
            return true;
        }

        public boolean canReceive() {
            return true;
        }
    }
}

