/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.luggage.entity;

import com.gizmo.luggage.LuggageMenu;
import com.gizmo.luggage.Registries;
import com.gizmo.luggage.entity.LuggageFollowOwnerGoal;
import com.gizmo.luggage.entity.LuggagePickupItemGoal;
import com.gizmo.luggage.network.LuggageNetworkHandler;
import com.gizmo.luggage.network.OpenLuggageScreenPacket;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class LuggageEntity
extends CreatureEntity
implements IInventoryChangedListener {
    private static final DataParameter<Boolean> EXTENDED = EntityDataManager.func_187226_a(LuggageEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Byte> TAME_FLAGS = EntityDataManager.func_187226_a(LuggageEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    protected static final DataParameter<Optional<UUID>> OWNER_ID = EntityDataManager.func_187226_a(LuggageEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    private Inventory inventory;
    private LazyOptional<?> itemHandler = null;
    public int lastSound = 0;
    public boolean tryingToFetchItem;

    public LuggageEntity(EntityType<? extends CreatureEntity> type, World level) {
        super(type, level);
        this.createInventory();
        this.func_184644_a(PathNodeType.LEAVES, -1.0f);
        this.func_184644_a(PathNodeType.FENCE, -1.0f);
        this.func_184644_a(PathNodeType.COCOA, -1.0f);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new LuggagePickupItemGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new LuggageFollowOwnerGoal(this, 1.1, 7.0f, 1.0f, false));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(EXTENDED, (Object)false);
        this.field_70180_af.func_187214_a(OWNER_ID, Optional.empty());
        this.field_70180_af.func_187214_a(TAME_FLAGS, (Object)0);
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 0.0).func_233815_a_(Attributes.field_233821_d_, 0.4);
    }

    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        ListNBT listtag = new ListNBT();
        tag.func_74757_a("Extended", this.hasExtendedInventory());
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            ItemStack itemstack = this.inventory.func_70301_a(i);
            if (itemstack.func_190926_b()) continue;
            CompoundNBT compoundtag = new CompoundNBT();
            compoundtag.func_74774_a("Slot", (byte)i);
            itemstack.func_77955_b(compoundtag);
            listtag.add((Object)compoundtag);
        }
        tag.func_218657_a("Items", (INBT)listtag);
        if (this.getOwnerUUID() != null) {
            tag.func_186854_a("Owner", this.getOwnerUUID());
        }
    }

    public void func_70037_a(CompoundNBT tag) {
        UUID uuid;
        super.func_70037_a(tag);
        ListNBT listtag = tag.func_150295_c("Items", 10);
        this.setExtendedInventory(tag.func_74767_n("Extended"));
        for (int i = 0; i < listtag.size(); ++i) {
            CompoundNBT compoundtag = listtag.func_150305_b(i);
            int j = compoundtag.func_74771_c("Slot") & 0xFF;
            if (j >= this.inventory.func_70302_i_()) continue;
            this.inventory.func_70299_a(j, ItemStack.func_199557_a((CompoundNBT)compoundtag));
        }
        if (tag.func_186855_b("Owner")) {
            uuid = tag.func_186857_a("Owner");
        } else {
            String s = tag.func_74779_i("Owner");
            uuid = PreYggdrasilConverter.func_187473_a((MinecraftServer)Objects.requireNonNull(this.func_184102_h()), (String)s);
        }
        if (uuid != null) {
            try {
                this.setOwnerUUID(uuid);
                this.setTame(true);
            }
            catch (Throwable throwable) {
                this.setTame(false);
            }
        }
    }

    private ItemStack convertToItem() {
        ITextComponent nameTag;
        ItemStack luggageItem = new ItemStack((IItemProvider)Registries.ItemRegistry.LUGGAGE.get());
        CompoundNBT tag = new CompoundNBT();
        if (this.hasExtendedInventory()) {
            tag.func_74757_a("Extended", this.hasExtendedInventory());
        }
        if (!this.inventory.func_191420_l()) {
            tag.func_218657_a("Inventory", (INBT)this.inventory.func_70487_g());
        }
        if (!tag.isEmpty()) {
            luggageItem.func_77982_d(tag);
        }
        if ((nameTag = this.func_200201_e()) != null && !nameTag.getString().isEmpty()) {
            luggageItem.func_200302_a(nameTag);
        }
        return luggageItem;
    }

    public void restoreFromStack(@Nonnull ItemStack stack) {
        if (stack.func_77973_b() != Registries.ItemRegistry.LUGGAGE.get()) {
            return;
        }
        CompoundNBT tag = stack.func_77978_p();
        if (tag != null && tag.func_74764_b("Extended")) {
            this.setExtendedInventory(tag.func_74767_n("Extended"));
        }
        if (tag != null && tag.func_74764_b("Inventory")) {
            this.inventory.func_70486_a(tag.func_150295_c("Inventory", 10));
            if (this.inventory.func_70302_i_() > 27) {
                this.setExtendedInventory(true);
            }
        }
        if (stack.func_82837_s()) {
            this.func_200203_b(stack.func_200301_q());
        }
    }

    private void createInventory() {
        Inventory simplecontainer = this.inventory;
        this.inventory = new Inventory(this.hasExtendedInventory() ? 54 : 27);
        if (simplecontainer != null) {
            simplecontainer.func_110132_b((IInventoryChangedListener)this);
            int i = Math.min(simplecontainer.func_70302_i_(), this.inventory.func_70302_i_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = simplecontainer.func_70301_a(j);
                if (itemstack.func_190926_b()) continue;
                this.inventory.func_70299_a(j, itemstack.func_77946_l());
            }
        }
        this.inventory.func_110134_a((IInventoryChangedListener)this);
        this.itemHandler = LazyOptional.of(() -> new InvWrapper((IInventory)this.inventory));
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public boolean hasExtendedInventory() {
        return (Boolean)this.field_70180_af.func_187225_a(EXTENDED);
    }

    public void setExtendedInventory(boolean extended) {
        this.field_70180_af.func_187227_b(EXTENDED, (Object)extended);
        this.createInventory();
    }

    public void func_76316_a(IInventory p_18983_) {
    }

    public boolean hasInventoryChanged(IInventory container) {
        return this.inventory != container;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (this.func_70089_S() && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.itemHandler != null) {
            return this.itemHandler.cast();
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.itemHandler != null) {
            LazyOptional<?> oldHandler = this.itemHandler;
            this.itemHandler = null;
            oldHandler.invalidate();
        }
    }

    @Nullable
    public UUID getOwnerUUID() {
        return ((Optional)this.field_70180_af.func_187225_a(OWNER_ID)).orElse(null);
    }

    public void setOwnerUUID(@Nullable UUID uuid) {
        this.field_70180_af.func_187227_b(OWNER_ID, Optional.ofNullable(uuid));
    }

    @Nullable
    public LivingEntity getOwner() {
        try {
            UUID uuid = this.getOwnerUUID();
            return uuid == null ? null : this.field_70170_p.func_217371_b(uuid);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    public void setTame(boolean p_21836_) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(TAME_FLAGS);
        if (p_21836_) {
            this.field_70180_af.func_187227_b(TAME_FLAGS, (Object)((byte)(b0 | 4)));
        } else {
            this.field_70180_af.func_187227_b(TAME_FLAGS, (Object)((byte)(b0 & 0xFFFFFFFB)));
        }
    }

    public void tame(PlayerEntity player) {
        this.setTame(true);
        this.setOwnerUUID(player.func_110124_au());
    }

    public void func_70636_d() {
        super.func_70636_d();
        ++this.lastSound;
    }

    public ActionResultType func_184199_a(PlayerEntity player, Vector3d vec, Hand hand) {
        if (this.func_70089_S()) {
            ItemStack stack = player.func_184586_b(hand);
            if (stack.func_77973_b() == Items.field_151057_cb) {
                return ActionResultType.PASS;
            }
            if (stack.func_190926_b()) {
                if (player.func_225608_bj_()) {
                    ItemStack luggageItem;
                    if (!this.field_70170_p.field_72995_K && player.field_71071_by.func_70441_a(luggageItem = this.convertToItem())) {
                        this.func_70106_y();
                        this.func_184185_a(SoundEvents.field_187638_cR, 0.5f, this.field_70146_Z.nextFloat() * 0.1f + 0.9f);
                    }
                } else {
                    this.func_184185_a(SoundEvents.field_187657_V, 0.5f, this.field_70146_Z.nextFloat() * 0.1f + 0.9f);
                    if (!this.field_70170_p.field_72995_K) {
                        ServerPlayerEntity sp = (ServerPlayerEntity)player;
                        if (sp.field_71070_bA != sp.field_71069_bz) {
                            sp.func_71053_j();
                        }
                        sp.func_71117_bO();
                        LuggageNetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new OpenLuggageScreenPacket(sp.field_71139_cq, this.func_145782_y()));
                        sp.field_71070_bA = new LuggageMenu(sp.field_71139_cq, sp.field_71071_by, (IInventory)this.inventory, this);
                        sp.field_71070_bA.func_75132_a((IContainerListener)sp);
                        MinecraftForge.EVENT_BUS.post((Event)new PlayerContainerEvent.Open((PlayerEntity)sp, sp.field_71070_bA));
                    }
                }
            }
        }
        return super.func_184199_a(player, vec, hand);
    }

    public boolean func_213397_c(double dist) {
        return false;
    }

    public boolean func_190530_aW() {
        return true;
    }

    public boolean func_180431_b(DamageSource source) {
        return true;
    }

    public void func_70606_j(float health) {
    }

    public boolean func_70617_f_() {
        return false;
    }

    public void func_241841_a(ServerWorld level, LightningBoltEntity lightningBolt) {
        if (!this.hasExtendedInventory()) {
            this.setExtendedInventory(true);
        } else {
            super.func_241841_a(level, lightningBolt);
        }
    }

    protected float func_189749_co() {
        return 0.95f;
    }

    public double func_233579_cu_() {
        return 0.2f;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return false;
    }

    public boolean func_184652_a(PlayerEntity player) {
        return false;
    }

    protected void func_180429_a(BlockPos pos, BlockState state) {
        this.func_184185_a(Registries.SoundRegistry.LUGGAGE_STEP, 0.15f, 0.7f + this.field_70146_Z.nextFloat() * 0.5f);
    }
}

