/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.luggage.entity;

import com.gizmo.luggage.LuggageMenu;
import com.gizmo.luggage.Registries;
import com.gizmo.luggage.entity.LuggageFollowOwnerGoal;
import com.gizmo.luggage.entity.LuggagePickupItemGoal;
import com.gizmo.luggage.network.LuggageNetworkHandler;
import com.gizmo.luggage.network.OpenLuggageScreenPacket;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.network.PacketDistributor;

public class LuggageEntity
extends PathfinderMob
implements OwnableEntity,
ContainerListener {
    private static final EntityDataAccessor<Boolean> EXTENDED = SynchedEntityData.m_135353_(LuggageEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Byte> TAME_FLAGS = SynchedEntityData.m_135353_(LuggageEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    protected static final EntityDataAccessor<Optional<UUID>> OWNER_ID = SynchedEntityData.m_135353_(LuggageEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private SimpleContainer inventory;
    private LazyOptional<?> itemHandler = null;
    private int soundCooldown = 15;
    private boolean tryingToFetchItem;

    public LuggageEntity(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
        this.createInventory();
        this.m_21441_(BlockPathTypes.LEAVES, -1.0f);
        this.m_21441_(BlockPathTypes.FENCE, -1.0f);
        this.m_21441_(BlockPathTypes.COCOA, -1.0f);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.m_21441_(BlockPathTypes.UNPASSABLE_RAIL, 0.0f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new LuggagePickupItemGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new LuggageFollowOwnerGoal(this, 1.1, 7.0f, 1.0f, false));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(EXTENDED, (Object)false);
        this.f_19804_.m_135372_(OWNER_ID, Optional.empty());
        this.f_19804_.m_135372_(TAME_FLAGS, (Object)0);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 0.0).m_22268_(Attributes.f_22279_, 0.4);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        ListTag listtag = new ListTag();
        tag.m_128379_("Extended", this.hasExtendedInventory());
        for (int i = 0; i < this.inventory.m_6643_(); ++i) {
            ItemStack itemstack = this.inventory.m_8020_(i);
            if (itemstack.m_41619_()) continue;
            CompoundTag compoundtag = new CompoundTag();
            compoundtag.m_128344_("Slot", (byte)i);
            itemstack.m_41739_(compoundtag);
            listtag.add((Object)compoundtag);
        }
        tag.m_128365_("Items", (Tag)listtag);
        if (this.m_142504_() != null) {
            tag.m_128362_("Owner", this.m_142504_());
        }
    }

    public void m_7378_(CompoundTag tag) {
        UUID uuid;
        super.m_7378_(tag);
        ListTag listtag = tag.m_128437_("Items", 10);
        this.setExtendedInventory(tag.m_128471_("Extended"));
        for (int i = 0; i < listtag.size(); ++i) {
            CompoundTag compoundtag = listtag.m_128728_(i);
            int j = compoundtag.m_128445_("Slot") & 0xFF;
            if (j >= this.inventory.m_6643_()) continue;
            this.inventory.m_6836_(j, ItemStack.m_41712_((CompoundTag)compoundtag));
        }
        if (tag.m_128403_("Owner")) {
            uuid = tag.m_128342_("Owner");
        } else {
            String s = tag.m_128461_("Owner");
            uuid = OldUsersConverter.m_11083_((MinecraftServer)Objects.requireNonNull(this.m_20194_()), (String)s);
        }
        if (uuid != null) {
            try {
                this.setOwnerUUID(uuid);
                this.setTame(true);
            }
            catch (Throwable throwable) {
                this.setTame(false);
            }
        }
    }

    private ItemStack convertToItem() {
        Component nameTag;
        ItemStack luggageItem = new ItemStack((ItemLike)Registries.ItemRegistry.LUGGAGE.get());
        CompoundTag tag = new CompoundTag();
        if (this.hasExtendedInventory()) {
            tag.m_128379_("Extended", this.hasExtendedInventory());
        }
        if (!this.inventory.m_7983_()) {
            tag.m_128365_("Inventory", (Tag)this.inventory.m_7927_());
        }
        if (!tag.m_128456_()) {
            luggageItem.m_41751_(tag);
        }
        if ((nameTag = this.m_7770_()) != null && !nameTag.getString().isEmpty()) {
            luggageItem.m_41714_(nameTag);
        }
        return luggageItem;
    }

    public void restoreFromStack(@Nonnull ItemStack stack) {
        if (!stack.m_150930_((Item)Registries.ItemRegistry.LUGGAGE.get())) {
            return;
        }
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_("Extended")) {
            this.setExtendedInventory(tag.m_128471_("Extended"));
        }
        if (tag != null && tag.m_128441_("Inventory")) {
            this.inventory.m_7797_(tag.m_128437_("Inventory", 10));
            if (this.inventory.m_6643_() > 27) {
                this.setExtendedInventory(true);
            }
        }
        if (stack.m_41788_()) {
            this.m_6593_(stack.m_41786_());
        }
    }

    private void createInventory() {
        SimpleContainer simplecontainer = this.inventory;
        this.inventory = new SimpleContainer(this.hasExtendedInventory() ? 54 : 27);
        if (simplecontainer != null) {
            simplecontainer.m_19181_((ContainerListener)this);
            int i = Math.min(simplecontainer.m_6643_(), this.inventory.m_6643_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = simplecontainer.m_8020_(j);
                if (itemstack.m_41619_()) continue;
                this.inventory.m_6836_(j, itemstack.m_41777_());
            }
        }
        this.inventory.m_19164_((ContainerListener)this);
        this.itemHandler = LazyOptional.of(() -> new InvWrapper((Container)this.inventory));
    }

    public SimpleContainer getInventory() {
        return this.inventory;
    }

    public boolean hasExtendedInventory() {
        return (Boolean)this.f_19804_.m_135370_(EXTENDED);
    }

    public void setExtendedInventory(boolean extended) {
        this.f_19804_.m_135381_(EXTENDED, (Object)extended);
        this.createInventory();
    }

    public void m_5757_(Container p_18983_) {
    }

    public boolean hasInventoryChanged(Container container) {
        return this.inventory != container;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (this.m_6084_() && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.itemHandler != null) {
            return this.itemHandler.cast();
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.itemHandler != null) {
            LazyOptional<?> oldHandler = this.itemHandler;
            this.itemHandler = null;
            oldHandler.invalidate();
        }
    }

    @Nullable
    public UUID m_142504_() {
        return ((Optional)this.f_19804_.m_135370_(OWNER_ID)).orElse(null);
    }

    public void setOwnerUUID(@Nullable UUID uuid) {
        this.f_19804_.m_135381_(OWNER_ID, Optional.ofNullable(uuid));
    }

    @Nullable
    public LivingEntity getOwner() {
        try {
            UUID uuid = this.m_142504_();
            return uuid == null ? null : this.f_19853_.m_46003_(uuid);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    public void setTame(boolean p_21836_) {
        byte b0 = (Byte)this.f_19804_.m_135370_(TAME_FLAGS);
        if (p_21836_) {
            this.f_19804_.m_135381_(TAME_FLAGS, (Object)((byte)(b0 | 4)));
        } else {
            this.f_19804_.m_135381_(TAME_FLAGS, (Object)((byte)(b0 & 0xFFFFFFFB)));
        }
    }

    public void tame(Player player) {
        this.setTame(true);
        this.setOwnerUUID(player.m_142081_());
    }

    public boolean isTryingToFetchItem() {
        return this.tryingToFetchItem;
    }

    public void setTryingToFetchItem(boolean fetch) {
        this.tryingToFetchItem = fetch;
    }

    public int getSoundCooldown() {
        return this.soundCooldown;
    }

    public void setSoundCooldown(int cooldown) {
        this.soundCooldown = cooldown;
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.soundCooldown > 0) {
            --this.soundCooldown;
        }
    }

    public InteractionResult m_7111_(Player player, Vec3 vec, InteractionHand hand) {
        if (this.m_6084_()) {
            ItemStack stack = player.m_21120_(hand);
            if (stack.m_150930_(Items.f_42656_)) {
                return InteractionResult.PASS;
            }
            if (stack.m_41619_()) {
                if (player.m_6144_()) {
                    if (!this.f_19853_.m_5776_()) {
                        ItemStack luggageItem = this.convertToItem();
                        if (player.m_150109_().m_36054_(luggageItem)) {
                            this.m_146870_();
                            this.m_5496_(SoundEvents.f_12019_, 0.5f, this.f_19796_.nextFloat() * 0.1f + 0.9f);
                        }
                    }
                } else {
                    this.f_19853_.m_142346_((Entity)player, GameEvent.f_157803_, player.m_142538_());
                    if (this.soundCooldown == 0) {
                        this.m_5496_(SoundEvents.f_11749_, 0.5f, this.f_19796_.nextFloat() * 0.1f + 0.9f);
                        this.soundCooldown = 5;
                    }
                    if (!this.f_19853_.m_5776_()) {
                        ServerPlayer sp = (ServerPlayer)player;
                        if (sp.f_36096_ != sp.f_36095_) {
                            sp.m_6915_();
                        }
                        sp.m_9217_();
                        LuggageNetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new OpenLuggageScreenPacket(sp.f_8940_, this.m_142049_()));
                        sp.f_36096_ = new LuggageMenu(sp.f_8940_, sp.m_150109_(), (Container)this.inventory, this);
                        sp.m_143399_(sp.f_36096_);
                        MinecraftForge.EVENT_BUS.post((Event)new PlayerContainerEvent.Open((Player)sp, sp.f_36096_));
                    }
                }
            }
        }
        return super.m_7111_(player, vec, hand);
    }

    public boolean m_6785_(double dist) {
        return false;
    }

    public boolean m_20147_() {
        return true;
    }

    public boolean m_6673_(DamageSource source) {
        return true;
    }

    public void m_21153_(float health) {
    }

    public boolean m_6147_() {
        return false;
    }

    public void m_8038_(ServerLevel level, LightningBolt lightningBolt) {
        if (!this.hasExtendedInventory()) {
            this.setExtendedInventory(true);
        } else {
            super.m_8038_(level, lightningBolt);
        }
    }

    public void m_147240_(double x, double y, double z) {
    }

    protected void m_6138_() {
    }

    public boolean m_147207_(MobEffectInstance instance, @Nullable Entity entity) {
        return false;
    }

    public boolean m_142535_(float dist, float mult, DamageSource source) {
        return false;
    }

    public void m_6043_() {
    }

    public void m_6074_() {
        this.getInventory().m_19195_().forEach(arg_0 -> ((LuggageEntity)this).m_19983_(arg_0));
        this.m_21373_();
        this.m_5496_(Registries.SoundRegistry.LUGGAGE_KILLED, 2.0f, 1.0f);
        this.m_142687_(Entity.RemovalReason.KILLED);
    }

    public boolean m_5789_() {
        return false;
    }

    public boolean m_5801_() {
        return false;
    }

    @Nullable
    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)Registries.ItemRegistry.LUGGAGE.get());
    }

    protected float m_6108_() {
        return 0.95f;
    }

    public double m_20204_() {
        return 0.2f;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return false;
    }

    public boolean m_6573_(Player player) {
        return false;
    }

    public boolean m_6090_() {
        return true;
    }

    public boolean m_20161_() {
        return true;
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(Registries.SoundRegistry.LUGGAGE_STEP, 0.15f, 0.7f + this.f_19796_.nextFloat() * 0.5f);
    }
}

