/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.luggage.entity;

import com.gizmo.luggage.Registries;
import com.gizmo.luggage.entity.LuggageEntity;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.Nullable;

public class LuggagePickupItemGoal
extends Goal {
    private final LuggageEntity luggage;
    private final PathNavigation navigation;
    @Nullable
    private ItemEntity targetItem = null;

    public LuggagePickupItemGoal(LuggageEntity luggage) {
        this.luggage = luggage;
        this.navigation = luggage.m_21573_();
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (!this.navigation.m_26571_()) {
            return false;
        }
        List items = this.luggage.f_19853_.m_6443_(ItemEntity.class, this.luggage.m_20191_().m_82400_(16.0), item -> (item.m_20096_() || item.m_20069_()) && this.luggage.getInventory().m_19183_(item.m_32055_()) && !item.m_32055_().m_150930_((Item)Registries.ItemRegistry.LUGGAGE.get()));
        items.sort(Comparator.comparingDouble(arg_0 -> ((LuggageEntity)this.luggage).m_20280_(arg_0)));
        if (!items.isEmpty()) {
            this.targetItem = (ItemEntity)items.get(0);
            return true;
        }
        return false;
    }

    public boolean m_8045_() {
        return this.luggage.m_6084_() && !this.navigation.m_26571_() && !this.navigation.m_26577_() && this.targetItem != null && !this.targetItem.m_213877_();
    }

    public void m_8056_() {
        if (this.targetItem != null) {
            this.navigation.m_5624_((Entity)this.targetItem, 1.2);
            this.luggage.setTryingToFetchItem(true);
        }
    }

    public void m_8041_() {
        this.luggage.setTryingToFetchItem(false);
    }

    public void m_8037_() {
        super.m_8037_();
        if (!this.luggage.f_19853_.m_5776_() && this.targetItem != null && this.luggage.m_20238_(this.targetItem.m_20182_()) < 2.5) {
            ItemStack item = this.targetItem.m_32055_();
            if (this.luggage.getInventory().m_19183_(this.targetItem.m_32055_())) {
                SimpleContainer simplecontainer;
                boolean flag;
                if (this.luggage.getSoundCooldown() == 0) {
                    boolean isFood = item.m_41614_();
                    this.luggage.m_5496_(isFood ? (SoundEvent)Registries.SoundRegistry.LUGGAGE_EAT_FOOD.get() : (SoundEvent)Registries.SoundRegistry.LUGGAGE_EAT_ITEM.get(), 0.5f, 1.0f + this.luggage.m_217043_().m_188501_() * 0.2f);
                    this.luggage.setSoundCooldown(15);
                }
                if (!(flag = (simplecontainer = this.luggage.getInventory()).m_19183_(item))) {
                    return;
                }
                this.luggage.m_21053_(this.targetItem);
                this.luggage.m_146852_(GameEvent.f_157806_, (Entity)this.luggage);
                this.luggage.m_7938_((Entity)this.targetItem, item.m_41613_());
                ItemStack consumedStack = simplecontainer.m_19173_(item);
                if (consumedStack.m_41619_()) {
                    this.targetItem.m_146870_();
                } else {
                    item.m_41764_(consumedStack.m_41613_());
                }
            }
        }
    }
}

