/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.luggage.entity;

import com.gizmo.luggage.LuggageMenu;
import com.gizmo.luggage.Registries;
import com.gizmo.luggage.entity.LuggageFollowOwnerGoal;
import com.gizmo.luggage.entity.LuggagePickupItemGoal;
import com.gizmo.luggage.network.OpenLuggageScreenPacket;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.minecraft.class_1263;
import net.minecraft.class_1265;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1538;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3321;
import net.minecraft.class_3417;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5712;
import net.minecraft.class_6025;
import net.minecraft.class_7;
import net.minecraft.server.MinecraftServer;

public class LuggageEntity
extends class_1314
implements class_6025,
class_1265 {
    private static final class_2940<Boolean> EXTENDED = class_2945.method_12791(LuggageEntity.class, (class_2941)class_2943.field_13323);
    protected static final class_2940<Byte> TAME_FLAGS = class_2945.method_12791(LuggageEntity.class, (class_2941)class_2943.field_13319);
    protected static final class_2940<Optional<UUID>> OWNER_ID = class_2945.method_12791(LuggageEntity.class, (class_2941)class_2943.field_13313);
    private class_1277 inventory;
    private InventoryStorage itemHandler = null;
    private int soundCooldown = 15;
    private boolean tryingToFetchItem;

    public LuggageEntity(class_1299<? extends class_1314> type, class_1937 level) {
        super(type, level);
        this.createInventory();
        this.method_5941(class_7.field_6, -1.0f);
        this.method_5941(class_7.field_10, -1.0f);
        this.method_5941(class_7.field_21516, -1.0f);
        this.method_5941(class_7.field_18, 0.0f);
        this.method_5941(class_7.field_25418, 0.0f);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new LuggagePickupItemGoal(this));
        this.field_6201.method_6277(2, (class_1352)new LuggageFollowOwnerGoal(this, 1.1, 7.0f, 1.0f, false));
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(EXTENDED, (Object)false);
        this.field_6011.method_12784(OWNER_ID, Optional.empty());
        this.field_6011.method_12784(TAME_FLAGS, (Object)0);
    }

    public static class_5132.class_5133 registerAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 0.0).method_26868(class_5134.field_23719, 0.4);
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        class_2499 listtag = new class_2499();
        tag.method_10556("Extended", this.hasExtendedInventory());
        for (int i = 0; i < this.inventory.method_5439(); ++i) {
            class_1799 itemstack = this.inventory.method_5438(i);
            if (itemstack.method_7960()) continue;
            class_2487 compoundtag = new class_2487();
            compoundtag.method_10567("Slot", (byte)i);
            itemstack.method_7953(compoundtag);
            listtag.add((Object)compoundtag);
        }
        tag.method_10566("Items", (class_2520)listtag);
        if (this.method_6139() != null) {
            tag.method_25927("Owner", this.method_6139());
        }
    }

    public void method_5749(class_2487 tag) {
        UUID uuid;
        super.method_5749(tag);
        class_2499 listtag = tag.method_10554("Items", 10);
        this.setExtendedInventory(tag.method_10577("Extended"));
        for (int i = 0; i < listtag.size(); ++i) {
            class_2487 compoundtag = listtag.method_10602(i);
            int j = compoundtag.method_10571("Slot") & 0xFF;
            if (j >= this.inventory.method_5439()) continue;
            this.inventory.method_5447(j, class_1799.method_7915((class_2487)compoundtag));
        }
        if (tag.method_25928("Owner")) {
            uuid = tag.method_25926("Owner");
        } else {
            String s = tag.method_10558("Owner");
            uuid = class_3321.method_14546((MinecraftServer)Objects.requireNonNull(this.method_5682()), (String)s);
        }
        if (uuid != null) {
            try {
                this.setOwnerUUID(uuid);
                this.setTame(true);
            }
            catch (Throwable throwable) {
                this.setTame(false);
            }
        }
    }

    private class_1799 convertToItem() {
        class_2561 nameTag;
        class_1799 luggageItem = new class_1799((class_1935)Registries.ItemRegistry.LUGGAGE);
        class_2487 tag = new class_2487();
        if (this.hasExtendedInventory()) {
            tag.method_10556("Extended", this.hasExtendedInventory());
        }
        if (!this.inventory.method_5442()) {
            tag.method_10566("Inventory", (class_2520)this.inventory.method_7660());
        }
        if (!tag.method_33133()) {
            luggageItem.method_7980(tag);
        }
        if ((nameTag = this.method_5797()) != null && !nameTag.getString().isEmpty()) {
            luggageItem.method_7977(nameTag);
        }
        return luggageItem;
    }

    public void restoreFromStack(@Nonnull class_1799 stack) {
        if (!stack.method_31574(Registries.ItemRegistry.LUGGAGE)) {
            return;
        }
        class_2487 tag = stack.method_7969();
        if (tag != null && tag.method_10545("Extended")) {
            this.setExtendedInventory(tag.method_10577("Extended"));
        }
        if (tag != null && tag.method_10545("Inventory")) {
            this.inventory.method_7659(tag.method_10554("Inventory", 10));
            if (this.inventory.method_5439() > 27) {
                this.setExtendedInventory(true);
            }
        }
        if (stack.method_7938()) {
            this.method_5665(stack.method_7964());
        }
    }

    private void createInventory() {
        class_1277 simplecontainer = this.inventory;
        this.inventory = new class_1277(this.hasExtendedInventory() ? 54 : 27);
        if (simplecontainer != null) {
            simplecontainer.method_5488((class_1265)this);
            int i = Math.min(simplecontainer.method_5439(), this.inventory.method_5439());
            for (int j = 0; j < i; ++j) {
                class_1799 itemstack = simplecontainer.method_5438(j);
                if (itemstack.method_7960()) continue;
                this.inventory.method_5447(j, itemstack.method_7972());
            }
        }
        this.inventory.method_5489((class_1265)this);
        this.itemHandler = InventoryStorage.of((class_1263)this.inventory, null);
    }

    public class_1277 getInventory() {
        return this.inventory;
    }

    public boolean hasExtendedInventory() {
        return (Boolean)this.field_6011.method_12789(EXTENDED);
    }

    public void setExtendedInventory(boolean extended) {
        this.field_6011.method_12778(EXTENDED, (Object)extended);
        this.createInventory();
    }

    public void method_5453(class_1263 p_18983_) {
    }

    public boolean hasInventoryChanged(class_1263 container) {
        return this.inventory != container;
    }

    public InventoryStorage getStorage() {
        return this.itemHandler;
    }

    @Nullable
    public UUID method_6139() {
        return ((Optional)this.field_6011.method_12789(OWNER_ID)).orElse(null);
    }

    public void setOwnerUUID(@Nullable UUID uuid) {
        this.field_6011.method_12778(OWNER_ID, Optional.ofNullable(uuid));
    }

    @Nullable
    public class_1309 getOwner() {
        try {
            UUID uuid = this.method_6139();
            return uuid == null ? null : this.field_6002.method_18470(uuid);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    public void setTame(boolean p_21836_) {
        byte b0 = (Byte)this.field_6011.method_12789(TAME_FLAGS);
        if (p_21836_) {
            this.field_6011.method_12778(TAME_FLAGS, (Object)((byte)(b0 | 4)));
        } else {
            this.field_6011.method_12778(TAME_FLAGS, (Object)((byte)(b0 & 0xFFFFFFFB)));
        }
    }

    public void tame(class_1657 player) {
        this.setTame(true);
        this.setOwnerUUID(player.method_5667());
    }

    public boolean isTryingToFetchItem() {
        return this.tryingToFetchItem;
    }

    public void setTryingToFetchItem(boolean fetch) {
        this.tryingToFetchItem = fetch;
    }

    public int getSoundCooldown() {
        return this.soundCooldown;
    }

    public void setSoundCooldown(int cooldown) {
        this.soundCooldown = cooldown;
    }

    public void method_6007() {
        super.method_6007();
        if (this.soundCooldown > 0) {
            --this.soundCooldown;
        }
    }

    public class_1269 method_5664(class_1657 player, class_243 vec, class_1268 hand) {
        if (this.method_5805()) {
            class_1799 stack = player.method_5998(hand);
            if (stack.method_31574(class_1802.field_8448)) {
                return class_1269.field_5811;
            }
            if (stack.method_7960()) {
                if (player.method_5715()) {
                    if (!this.field_6002.method_8608()) {
                        class_1799 luggageItem = this.convertToItem();
                        if (player.method_31548().method_7394(luggageItem)) {
                            this.method_31472();
                            this.method_5783(class_3417.field_15197, 0.5f, this.field_5974.method_43057() * 0.1f + 0.9f);
                        }
                    }
                } else {
                    this.field_6002.method_33596((class_1297)player, class_5712.field_28176, player.method_24515());
                    if (this.soundCooldown == 0) {
                        this.method_5783(class_3417.field_14982, 0.5f, this.field_5974.method_43057() * 0.1f + 0.9f);
                        this.soundCooldown = 5;
                    }
                    if (!this.field_6002.method_8608()) {
                        class_3222 sp = (class_3222)player;
                        if (sp.field_7512 != sp.field_7498) {
                            sp.method_7346();
                        }
                        sp.method_14237();
                        ServerPlayNetworking.send((class_3222)sp, (class_2960)OpenLuggageScreenPacket.getID(), (class_2540)new OpenLuggageScreenPacket(sp.field_13986, this.method_5628()).encode());
                        sp.field_7512 = new LuggageMenu(sp.field_13986, sp.method_31548(), (class_1263)this.inventory, this);
                        sp.method_14235(sp.field_7512);
                    }
                }
            }
        }
        return super.method_5664(player, vec, hand);
    }

    public boolean method_5974(double dist) {
        return false;
    }

    public boolean method_5655() {
        return true;
    }

    public boolean method_5679(class_1282 source) {
        return true;
    }

    public void method_6033(float health) {
    }

    public boolean method_6101() {
        return false;
    }

    public void method_5800(class_3218 level, class_1538 lightningBolt) {
        if (!this.hasExtendedInventory()) {
            this.setExtendedInventory(true);
        } else {
            super.method_5800(level, lightningBolt);
        }
    }

    public void method_6005(double x, double y, double z) {
    }

    protected void method_6070() {
    }

    public boolean method_37222(class_1293 instance, @Nullable class_1297 entity) {
        return false;
    }

    public boolean method_5747(float dist, float mult, class_1282 source) {
        return false;
    }

    public void method_5982() {
    }

    public void method_5768() {
        this.getInventory().method_24514().forEach(arg_0 -> ((LuggageEntity)this).method_5775(arg_0));
        this.method_5990();
        this.method_5783(Registries.SoundRegistry.LUGGAGE_KILLED, 2.0f, 1.0f);
        this.method_5650(class_1297.class_5529.field_26998);
    }

    public boolean method_6102() {
        return false;
    }

    public boolean method_6086() {
        return false;
    }

    @Nullable
    public class_1799 method_31480() {
        return new class_1799((class_1935)Registries.ItemRegistry.LUGGAGE);
    }

    protected float method_6120() {
        return 0.95f;
    }

    public double method_29241() {
        return 0.2f;
    }

    public boolean method_5643(class_1282 source, float amount) {
        return false;
    }

    public boolean method_5931(class_1657 player) {
        return false;
    }

    public boolean method_5696() {
        return true;
    }

    public boolean method_21749() {
        return true;
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_5783(Registries.SoundRegistry.LUGGAGE_STEP, 0.05f, 0.7f + this.field_5974.method_43057() * 0.5f);
    }
}

