/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.luggage.entity;

import com.gizmo.luggage.entity.LuggageEntity;
import java.util.EnumSet;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_14;
import net.minecraft.class_1408;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2397;
import net.minecraft.class_2680;
import net.minecraft.class_4538;
import net.minecraft.class_7;

public class LuggageFollowOwnerGoal
extends class_1352 {
    private final LuggageEntity luggage;
    private class_1309 owner;
    private final class_4538 level;
    private final double speedModifier;
    private final class_1408 navigation;
    private int timeToRecalcPath;
    private final float stopDistance;
    private final float startDistance;
    private float oldWaterCost;
    private final boolean canFly;

    public LuggageFollowOwnerGoal(LuggageEntity luggage, double speed, float startDist, float stopDist, boolean fly) {
        this.luggage = luggage;
        this.level = luggage.field_6002;
        this.speedModifier = speed;
        this.navigation = luggage.method_5942();
        this.startDistance = startDist;
        this.stopDistance = stopDist;
        this.canFly = fly;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    public boolean method_6264() {
        class_1309 livingentity = this.luggage.getOwner();
        if (livingentity == null) {
            return false;
        }
        if (livingentity.method_7325()) {
            return false;
        }
        if (this.luggage.isTryingToFetchItem()) {
            return false;
        }
        if (this.luggage.method_5858((class_1297)livingentity) < (double)(this.startDistance * this.startDistance)) {
            return false;
        }
        this.owner = livingentity;
        return true;
    }

    public boolean method_6266() {
        if (this.navigation.method_6357()) {
            return false;
        }
        return !(this.luggage.method_5858((class_1297)this.owner) <= (double)(this.stopDistance * this.stopDistance));
    }

    public void method_6269() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.luggage.method_5944(class_7.field_18);
        this.luggage.method_5941(class_7.field_18, 0.0f);
    }

    public void method_6270() {
        this.owner = null;
        this.navigation.method_6340();
        this.luggage.method_5941(class_7.field_18, this.oldWaterCost);
    }

    public void method_6268() {
        this.luggage.method_5988().method_6226((class_1297)this.owner, 10.0f, (float)this.luggage.method_5978());
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = this.method_38847(10);
            if (!this.luggage.method_5934() && !this.luggage.method_5765()) {
                if (this.luggage.method_5858((class_1297)this.owner) >= 1600.0) {
                    this.teleportToOwner();
                } else {
                    this.navigation.method_6335((class_1297)this.owner, this.speedModifier);
                }
            }
        }
    }

    private void teleportToOwner() {
        class_2338 blockpos = this.owner.method_24515();
        for (int i = 0; i < 10; ++i) {
            int j = this.randomIntInclusive(-3, 3);
            int k = this.randomIntInclusive(-1, 1);
            int l = this.randomIntInclusive(-3, 3);
            boolean flag = this.maybeTeleportTo(blockpos.method_10263() + j, blockpos.method_10264() + k, blockpos.method_10260() + l);
            if (!flag) continue;
            return;
        }
    }

    private boolean maybeTeleportTo(int x, int y, int z) {
        if (Math.abs((double)x - this.owner.method_23317()) < 2.0 && Math.abs((double)z - this.owner.method_23321()) < 2.0) {
            return false;
        }
        if (!this.canTeleportTo(new class_2338(x, y, z))) {
            return false;
        }
        this.luggage.method_5808((double)x + 0.5, y, (double)z + 0.5, this.luggage.method_36454(), this.luggage.method_36455());
        this.navigation.method_6340();
        return true;
    }

    private boolean canTeleportTo(class_2338 pos) {
        class_7 blockpathtypes = class_14.method_23476((class_1922)this.level, (class_2338.class_2339)pos.method_25503());
        if (blockpathtypes != class_7.field_12) {
            return false;
        }
        class_2680 blockstate = this.level.method_8320(pos.method_10074());
        if (!this.canFly && blockstate.method_26204() instanceof class_2397) {
            return false;
        }
        class_2338 blockpos = pos.method_10059((class_2382)this.luggage.method_24515());
        return this.level.method_8587((class_1297)this.luggage, this.luggage.method_5829().method_996(blockpos));
    }

    private int randomIntInclusive(int min, int max) {
        return this.luggage.method_6051().method_43048(max - min + 1) + min;
    }
}

