/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.luggage.network;

import com.gizmo.luggage.LuggageMenu;
import com.gizmo.luggage.client.LuggageScreen;
import com.gizmo.luggage.entity.LuggageEntity;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class OpenLuggageScreenPacket {
    private final int containerId;
    private final int entityId;

    public OpenLuggageScreenPacket(int containerId, int entityId) {
        this.containerId = containerId;
        this.entityId = entityId;
    }

    public OpenLuggageScreenPacket(FriendlyByteBuf buf) {
        this.containerId = buf.readUnsignedByte();
        this.entityId = buf.readInt();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeByte(this.containerId);
        buf.writeInt(this.entityId);
    }

    public int getContainerId() {
        return this.containerId;
    }

    public int getEntityId() {
        return this.entityId;
    }

    public static class Handler {
        public static boolean onMessage(final OpenLuggageScreenPacket message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(new Runnable(){

                @Override
                public void run() {
                    assert (Minecraft.m_91087_().f_91073_ != null);
                    Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(message.getEntityId());
                    if (entity instanceof LuggageEntity) {
                        LuggageEntity luggage = (LuggageEntity)entity;
                        LocalPlayer localplayer = Minecraft.m_91087_().f_91074_;
                        SimpleContainer simplecontainer = new SimpleContainer(luggage.hasExtendedInventory() ? 54 : 27);
                        assert (localplayer != null);
                        LuggageMenu menu = new LuggageMenu(message.getContainerId(), localplayer.m_150109_(), (Container)simplecontainer, luggage);
                        localplayer.f_36096_ = menu;
                        Minecraft.m_91087_().m_91152_((Screen)new LuggageScreen(menu, localplayer.m_150109_(), luggage));
                    }
                }
            });
            ctx.get().setPacketHandled(true);
            return true;
        }
    }
}

