/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty;

import com.majruszs_difficulty.Instances;
import com.mlib.WorldHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class GameState {
    public static final TextFormatting NORMAL_MODE_COLOR = TextFormatting.WHITE;
    public static final TextFormatting EXPERT_MODE_COLOR = TextFormatting.RED;
    public static final TextFormatting MASTER_MODE_COLOR = TextFormatting.DARK_PURPLE;
    private static State CURRENT = State.NORMAL;

    public static boolean changeMode(State state) {
        if (state == CURRENT) {
            return false;
        }
        CURRENT = state;
        return true;
    }

    public static boolean changeModeWithAdvancement(State state, MinecraftServer minecraftServer) {
        if (!GameState.changeMode(state)) {
            return false;
        }
        GameState.triggerAdvancement(minecraftServer);
        return true;
    }

    public static void triggerAdvancement(MinecraftServer minecraftServer) {
        minecraftServer.func_184103_al().func_181057_v().forEach(GameState::triggerAdvancement);
    }

    public static void triggerAdvancement(ServerPlayerEntity player) {
        Instances.GAME_STATE_TRIGGER.trigger(player, CURRENT);
    }

    public static State getCurrentMode() {
        return CURRENT;
    }

    public static boolean atLeast(State state) {
        return GameState.getValueDependingOnGameState(state, true, CURRENT == State.EXPERT || CURRENT == State.MASTER, CURRENT == State.MASTER);
    }

    public static int convertStateToInteger(State state) {
        return GameState.getValueDependingOnGameState(state, 0, 1, 2);
    }

    public static State convertIntegerToState(int mode) {
        switch (mode) {
            default: {
                return State.NORMAL;
            }
            case 1: {
                return State.EXPERT;
            }
            case 2: 
        }
        return State.MASTER;
    }

    public static <ConfigType> ConfigType getValueDependingOnGameState(State state, ConfigType normal, ConfigType expert, ConfigType master) {
        switch (state) {
            default: {
                return normal;
            }
            case EXPERT: {
                return expert;
            }
            case MASTER: 
        }
        return master;
    }

    public static <ConfigType> ConfigType getValueDependingOnCurrentGameState(ConfigType normal, ConfigType expert, ConfigType master) {
        return GameState.getValueDependingOnGameState(CURRENT, normal, expert, master);
    }

    public static IFormattableTextComponent getGameStateText(State state) {
        String modeName = GameState.getValueDependingOnGameState(state, "normal", "expert", "master");
        TextFormatting textColor = GameState.getValueDependingOnGameState(state, NORMAL_MODE_COLOR, EXPERT_MODE_COLOR, MASTER_MODE_COLOR);
        return GameState.generateModeText(modeName, textColor);
    }

    public static double getRegionalDifficulty(LivingEntity target) {
        double clampedRegionalDifficulty = target != null ? WorldHelper.getClampedRegionalDifficulty((Entity)target) : 0.25;
        double stateModifier = GameState.getStateModifier();
        return MathHelper.func_151237_a((double)(clampedRegionalDifficulty + stateModifier), (double)0.0, (double)1.0);
    }

    public static double getStateModifier() {
        return GameState.getValueDependingOnCurrentGameState(0.0, 0.15, 0.3);
    }

    private static IFormattableTextComponent generateModeText(String modeName, TextFormatting color) {
        TranslationTextComponent text = new TranslationTextComponent("majruszs_difficulty.states." + modeName);
        text.func_240701_a_(new TextFormatting[]{color, TextFormatting.BOLD});
        return text;
    }

    public static enum State {
        NORMAL,
        EXPERT,
        MASTER;

    }
}

