/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.PillagerEntity;
import net.minecraft.entity.monster.WitchEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class MajruszsHelper {
    @Nullable
    public static PlayerEntity getPlayerFromDamageSource(DamageSource damageSource) {
        return damageSource.func_76346_g() instanceof PlayerEntity ? (PlayerEntity)damageSource.func_76346_g() : null;
    }

    public static boolean isHuman(@Nullable Entity entity) {
        return entity instanceof PlayerEntity || entity instanceof VillagerEntity || entity instanceof PillagerEntity || entity instanceof WitchEntity;
    }

    public static boolean isAnimal(@Nullable Entity entity) {
        return entity instanceof AnimalEntity;
    }

    public static void addAdvancedTooltip(List<ITextComponent> tooltip, ITooltipFlag flag, String translationKey) {
        if (flag.func_194127_a()) {
            tooltip.add((ITextComponent)new TranslationTextComponent(translationKey).func_240699_a_(TextFormatting.GRAY));
        }
    }

    public static void addAdvancedTooltips(List<ITextComponent> tooltip, ITooltipFlag flag, String ... translationKeys) {
        if (flag.func_194127_a()) {
            for (String translationKey : translationKeys) {
                MajruszsHelper.addAdvancedTooltip(tooltip, flag, translationKey);
            }
        }
    }

    public static IFormattableTextComponent getDisabledItemTooltip() {
        return new TranslationTextComponent("majruszs_difficulty.items.disabled_tooltip").func_240701_a_(new TextFormatting[]{TextFormatting.RED, TextFormatting.BOLD});
    }

    public static void addExtraTooltipIfDisabled(List<ITextComponent> toolTip, boolean isEnabled) {
        if (!isEnabled) {
            toolTip.add((ITextComponent)MajruszsHelper.getDisabledItemTooltip());
        }
    }
}

