/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty;

import com.majruszs_difficulty.GameDataSaver;
import com.majruszs_difficulty.Instances;
import com.majruszs_difficulty.RegistryHandlerClient;
import com.majruszs_difficulty.commands.ChangeGameStateCommand;
import com.majruszs_difficulty.commands.GetDifficultyCommand;
import com.majruszs_difficulty.commands.UndeadArmyManagerCommand;
import com.majruszs_difficulty.entities.CreeperlingEntity;
import com.majruszs_difficulty.entities.EliteSkeletonEntity;
import com.majruszs_difficulty.entities.GiantEntity;
import com.majruszs_difficulty.entities.PillagerWolfEntity;
import com.majruszs_difficulty.entities.SkyKeeperEntity;
import com.majruszs_difficulty.features.treasure_bag.TreasureBagManager;
import com.majruszs_difficulty.features.undead_army.ReloadUndeadArmyGoals;
import com.majruszs_difficulty.features.undead_army.UndeadArmyManager;
import com.majruszs_difficulty.generation.OreGeneration;
import com.majruszs_difficulty.generation.structures.NoFeatureBaseStructure;
import com.majruszs_difficulty.items.AttributeArmorItem;
import com.majruszs_difficulty.items.FakeItem;
import com.mlib.items.SpawnEggFactory;
import com.mojang.brigadier.CommandDispatcher;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.particles.ParticleType;
import net.minecraft.potion.Effect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraft.world.gen.FlatChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class RegistryHandler {
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"majruszs_difficulty");
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"majruszs_difficulty");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"majruszs_difficulty");
    public static final DeferredRegister<SoundEvent> SOUNDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"majruszs_difficulty");
    public static final DeferredRegister<Effect> EFFECTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.POTIONS, (String)"majruszs_difficulty");
    public static final DeferredRegister<Structure<?>> STRUCTURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STRUCTURE_FEATURES, (String)"majruszs_difficulty");
    public static final DeferredRegister<ParticleType<?>> PARTICLES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PARTICLE_TYPES, (String)"majruszs_difficulty");
    public static UndeadArmyManager UNDEAD_ARMY_MANAGER;
    public static GameDataSaver GAME_DATA_SAVER;

    public static void init() {
        FMLJavaModLoadingContext loadingContext = FMLJavaModLoadingContext.get();
        IEventBus modEventBus = loadingContext.getModEventBus();
        RegistryHandler.registerEverything(modEventBus);
        modEventBus.addListener(RegistryHandler::setup);
        modEventBus.addListener(RegistryHandler::setupClient);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> modEventBus.addListener(RegistryHandler::onTextureStitch));
        IEventBus forgeEventBus = MinecraftForge.EVENT_BUS;
        forgeEventBus.addListener(RegistryHandler::onLoadingWorld);
        forgeEventBus.addListener(RegistryHandler::onSavingWorld);
        forgeEventBus.addListener(RegistryHandler::onServerStart);
        forgeEventBus.addListener(RegistryHandler::registerCommands);
    }

    private static void registerEntities(IEventBus modEventBus) {
        ENTITIES.register("giant", () -> GiantEntity.type);
        ENTITIES.register("pillager_wolf", () -> PillagerWolfEntity.type);
        ENTITIES.register("elite_skeleton", () -> EliteSkeletonEntity.type);
        ENTITIES.register("sky_keeper", () -> SkyKeeperEntity.type);
        ENTITIES.register("creeperling", () -> CreeperlingEntity.type);
        ENTITIES.register(modEventBus);
    }

    private static void registerSpawnEggs() {
        SpawnEggFactory.setDefaultItemGroup((ItemGroup)Instances.ITEM_GROUP);
        SpawnEggFactory.createRegistrySpawnEgg(ITEMS, (String)"giant_spawn_egg", GiantEntity.type, (int)44975, (int)7969893);
        SpawnEggFactory.createRegistrySpawnEgg(ITEMS, (String)"pillager_wolf_spawn_egg", PillagerWolfEntity.type, (int)0x959B9B, (int)5451574);
        SpawnEggFactory.createRegistrySpawnEgg(ITEMS, (String)"illusioner_spawn_egg", (EntityType)EntityType.field_200764_D, (int)1268375, (int)0x959B9B);
        SpawnEggFactory.createRegistrySpawnEgg(ITEMS, (String)"elite_skeleton_spawn_egg", EliteSkeletonEntity.type, (int)0xC1C1C1, (int)16664653);
        SpawnEggFactory.createRegistrySpawnEgg(ITEMS, (String)"sky_keeper_spawn_egg", SkyKeeperEntity.type, (int)8078765, (int)0xF0F0F0);
        SpawnEggFactory.createRegistrySpawnEgg(ITEMS, (String)"creeperling_spawn_egg", CreeperlingEntity.type, (int)894731, (int)0);
    }

    private static void registerFakeItems(String ... registerNames) {
        for (String registerName : registerNames) {
            ITEMS.register("advancement_" + registerName, FakeItem::new);
        }
    }

    private static void registerFakeItems() {
        RegistryHandler.registerFakeItems("normal", "expert", "master", "bleeding");
    }

    private static void registerTreasureBags() {
        Instances.UNDEAD_ARMY_TREASURE_BAG.register();
        Instances.ELDER_GUARDIAN_TREASURE_BAG.register();
        Instances.WITHER_TREASURE_BAG.register();
        Instances.ENDER_DRAGON_TREASURE_BAG.register();
        Instances.FISHING_TREASURE_BAG.register();
        Instances.PILLAGER_TREASURE_BAG.register();
    }

    private static void registerItems(IEventBus modEventBus) {
        ITEMS.register("wither_sword", () -> Instances.WITHER_SWORD);
        ITEMS.register("hermes_boots", () -> Instances.HERMES_BOOTS_ITEM);
        ITEMS.register("end_shard", () -> Instances.END_SHARD_ITEM);
        ITEMS.register("end_ingot", () -> Instances.END_INGOT_ITEM);
        ITEMS.register("end_sword", () -> Instances.END_SWORD_ITEM);
        ITEMS.register("end_shovel", () -> Instances.END_SHOVEL_ITEM);
        ITEMS.register("end_pickaxe", () -> Instances.END_PICKAXE_ITEM);
        ITEMS.register("end_axe", () -> Instances.END_AXE_ITEM);
        ITEMS.register("end_hoe", () -> Instances.END_HOE_ITEM);
        ITEMS.register("end_helmet", () -> Instances.END_HELMET_ITEM);
        ITEMS.register("end_chestplate", () -> Instances.END_CHESTPLATE_ITEM);
        ITEMS.register("end_leggings", () -> Instances.END_LEGGINGS_ITEM);
        ITEMS.register("end_boots", () -> Instances.END_BOOTS_ITEM);
        ITEMS.register("end_shard_locator", () -> Instances.END_SHARD_LOCATOR_ITEM);
        ITEMS.register("tattered_cloth", () -> Instances.TATTERED_CLOTH_ITEM);
        ITEMS.register("undead_battle_standard", () -> Instances.BATTLE_STANDARD_ITEM);
        ITEMS.register("bandage", () -> Instances.BANDAGE_ITEM);
        ITEMS.register("golden_bandage", () -> Instances.GOLDEN_BANDAGE_ITEM);
        ITEMS.register("recall_potion", () -> Instances.RECALL_POTION_ITEM);
        ITEMS.register("ocean_shield", () -> Instances.OCEAN_SHIELD_ITEM);
        RegistryHandler.registerTreasureBags();
        RegistryHandler.registerSpawnEggs();
        RegistryHandler.registerFakeItems();
        ITEMS.register(modEventBus);
    }

    private static void registerBlocks(IEventBus modEventBus) {
        BLOCKS.register("end_shard_ore", () -> Instances.END_SHARD_ORE);
        ITEMS.register("end_shard_ore", () -> Instances.END_SHARD_ORE_ITEM);
        BLOCKS.register("end_block", () -> Instances.END_BLOCK);
        ITEMS.register("end_block", () -> Instances.END_BLOCK_ITEM);
        BLOCKS.register("infested_end_stone", () -> Instances.INFESTED_END_STONE);
        ITEMS.register("infested_end_stone", () -> Instances.INFESTED_END_STONE_ITEM);
        BLOCKS.register(modEventBus);
    }

    private static void registerSounds(IEventBus modEventBus) {
        SOUNDS.register("undead_army.approaching", () -> Instances.Sounds.UNDEAD_ARMY_APPROACHING);
        SOUNDS.register("undead_army.wave_started", () -> Instances.Sounds.UNDEAD_ARMY_WAVE_STARTED);
        SOUNDS.register(modEventBus);
    }

    private static void registerEffects(IEventBus modEventBus) {
        EFFECTS.register("bleeding", () -> Instances.BLEEDING);
        EFFECTS.register("bleeding_immunity", () -> Instances.BLEEDING_IMMUNITY);
        EFFECTS.register(modEventBus);
    }

    private static void registerParticles(IEventBus modEventBus) {
        PARTICLES.register("blood_particle", () -> Instances.BLOOD_PARTICLE);
        PARTICLES.register(modEventBus);
    }

    private static void registerStructures(IEventBus modEventBus) {
        STRUCTURES.register("flying_phantom_structure", () -> Instances.FLYING_PHANTOM);
        STRUCTURES.register("flying_end_island", () -> Instances.FLYING_END_ISLAND);
        STRUCTURES.register("flying_end_ship", () -> Instances.FLYING_END_SHIP);
        STRUCTURES.register(modEventBus);
        Structure.field_236365_a_.put((Object)"flying_phantom_structure", (Object)Instances.FLYING_PHANTOM);
        Structure.field_236365_a_.put((Object)"flying_end_island", (Object)Instances.FLYING_END_ISLAND);
        Structure.field_236365_a_.put((Object)"flying_end_ship", (Object)Instances.FLYING_END_SHIP);
    }

    private static void registerEverything(IEventBus modEventBus) {
        RegistryHandler.registerEntities(modEventBus);
        RegistryHandler.registerBlocks(modEventBus);
        RegistryHandler.registerItems(modEventBus);
        RegistryHandler.registerSounds(modEventBus);
        RegistryHandler.registerEffects(modEventBus);
        RegistryHandler.registerParticles(modEventBus);
        RegistryHandler.registerStructures(modEventBus);
    }

    private static void setupClient(FMLClientSetupEvent event) {
        RegistryHandlerClient.setup();
    }

    private static void setup(FMLCommonSetupEvent event) {
        GlobalEntityTypeAttributes.put(GiantEntity.type, (AttributeModifierMap)GiantEntity.getAttributeMap());
        GlobalEntityTypeAttributes.put(PillagerWolfEntity.type, (AttributeModifierMap)PillagerWolfEntity.getAttributeMap());
        GlobalEntityTypeAttributes.put(EliteSkeletonEntity.type, (AttributeModifierMap)EliteSkeletonEntity.getAttributeMap());
        GlobalEntityTypeAttributes.put(SkyKeeperEntity.type, (AttributeModifierMap)SkyKeeperEntity.getAttributeMap());
        GlobalEntityTypeAttributes.put(CreeperlingEntity.type, (AttributeModifierMap)CreeperlingEntity.getAttributeMap());
        EntitySpawnPlacementRegistry.func_209343_a(GiantEntity.type, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223325_c);
        EntitySpawnPlacementRegistry.func_209343_a(PillagerWolfEntity.type, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AnimalEntity::func_223316_b);
        EntitySpawnPlacementRegistry.func_209343_a(EliteSkeletonEntity.type, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223325_c);
        EntitySpawnPlacementRegistry.func_209343_a(SkyKeeperEntity.type, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MobEntity::func_223315_a);
        EntitySpawnPlacementRegistry.func_209343_a(CreeperlingEntity.type, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MobEntity::func_223315_a);
        event.enqueueWork(Instances.FLYING_PHANTOM::setup);
        event.enqueueWork(Instances.FLYING_END_ISLAND::setup);
        event.enqueueWork(Instances.FLYING_END_SHIP::setup);
        OreGeneration.registerOres();
        AttributeArmorItem.updateAllItemsAttributes();
    }

    private static void registerCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        ChangeGameStateCommand.register((CommandDispatcher<CommandSource>)dispatcher);
        UndeadArmyManagerCommand.register((CommandDispatcher<CommandSource>)dispatcher);
        GetDifficultyCommand.register((CommandDispatcher<CommandSource>)dispatcher);
    }

    private static void onServerStart(FMLServerStartingEvent event) {
        MinecraftServer server = event.getServer();
        UNDEAD_ARMY_MANAGER.updateWorld(server.func_241755_D_());
        TreasureBagManager.addTreasureBagTo(EntityType.field_200800_n, Instances.ELDER_GUARDIAN_TREASURE_BAG, false);
        TreasureBagManager.addTreasureBagTo(EntityType.field_200760_az, Instances.WITHER_TREASURE_BAG, false);
        TreasureBagManager.addTreasureBagTo(EntityType.field_200802_p, Instances.ENDER_DRAGON_TREASURE_BAG, false);
    }

    public static void onLoadingWorld(WorldEvent.Load event) {
        if (!(event.getWorld() instanceof ServerWorld)) {
            return;
        }
        ServerWorld world = (ServerWorld)event.getWorld();
        DimensionSavedDataManager manager = world.func_217481_x();
        UNDEAD_ARMY_MANAGER = (UndeadArmyManager)manager.func_215752_a(() -> new UndeadArmyManager(world), "undead_army");
        UNDEAD_ARMY_MANAGER.updateWorld(world);
        GAME_DATA_SAVER = (GameDataSaver)manager.func_215752_a(GameDataSaver::new, "majruszs_difficulty");
        GAME_DATA_SAVER.updateGameState();
        ReloadUndeadArmyGoals.resetTimer();
        if (event.getWorld() instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)event.getWorld();
            if (serverWorld.func_72863_F().func_201711_g() instanceof FlatChunkGenerator && serverWorld.func_234923_W_().equals(World.field_234918_g_)) {
                return;
            }
            HashMap<NoFeatureBaseStructure, Object> tempMap = new HashMap<NoFeatureBaseStructure, Object>(serverWorld.func_72863_F().field_186029_c.func_235957_b_().func_236195_a_());
            tempMap.putIfAbsent(Instances.FLYING_PHANTOM, DimensionStructuresSettings.field_236191_b_.get((Object)Instances.FLYING_PHANTOM));
            tempMap.putIfAbsent(Instances.FLYING_END_ISLAND, DimensionStructuresSettings.field_236191_b_.get((Object)Instances.FLYING_END_ISLAND));
            tempMap.putIfAbsent(Instances.FLYING_END_SHIP, DimensionStructuresSettings.field_236191_b_.get((Object)Instances.FLYING_END_SHIP));
            serverWorld.func_72863_F().field_186029_c.func_235957_b_().field_236193_d_ = tempMap;
        }
    }

    public static void onSavingWorld(WorldEvent.Save event) {
        if (!(event.getWorld() instanceof ServerWorld)) {
            return;
        }
        GAME_DATA_SAVER.func_76185_a();
        UNDEAD_ARMY_MANAGER.func_76185_a();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void onTextureStitch(TextureStitchEvent.Pre event) {
        AtlasTexture map = event.getMap();
        if (PlayerContainer.field_226615_c_.equals((Object)map.func_229223_g_())) {
            event.addSprite(RegistryHandlerClient.OCEAN_SHIELD_MATERIAL.func_229313_b_());
        }
    }
}

