/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.commands;

import com.majruszs_difficulty.GameState;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public final class ChangeGameStateCommand {
    private ChangeGameStateCommand() {
    }

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"currentgamestate").requires(source -> source.func_197034_c(0))).executes(entity -> ChangeGameStateCommand.getCurrentState((CommandSource)entity.getSource())));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"gamestate").requires(source -> source.func_197034_c(4))).then(Commands.func_197057_a((String)"normal").executes(entity -> ChangeGameStateCommand.changeState((CommandSource)entity.getSource(), GameState.State.NORMAL)))).then(Commands.func_197057_a((String)"expert").executes(entity -> ChangeGameStateCommand.changeState((CommandSource)entity.getSource(), GameState.State.EXPERT)))).then(Commands.func_197057_a((String)"master").executes(entity -> ChangeGameStateCommand.changeState((CommandSource)entity.getSource(), GameState.State.MASTER))));
    }

    public static int getCurrentState(CommandSource source) {
        source.func_197030_a((ITextComponent)ChangeGameStateCommand.getFeedbackMessage(GameState.getCurrentMode(), "current"), true);
        return GameState.convertStateToInteger(GameState.getCurrentMode());
    }

    public static int changeState(CommandSource source, GameState.State state) {
        if (GameState.changeModeWithAdvancement(state, source.func_197028_i())) {
            source.func_197030_a((ITextComponent)ChangeGameStateCommand.getFeedbackMessage(state, "change"), true);
        }
        return GameState.convertStateToInteger(state);
    }

    private static IFormattableTextComponent getFeedbackMessage(GameState.State state, String translationPart) {
        TranslationTextComponent feedback = new TranslationTextComponent("commands.game_state." + translationPart);
        IFormattableTextComponent feedback_mode = GameState.getGameStateText(state);
        feedback.func_240702_b_(" ");
        feedback.func_230529_a_((ITextComponent)feedback_mode);
        feedback.func_240702_b_("!");
        return feedback;
    }
}

