/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.commands;

import com.majruszs_difficulty.GameState;
import com.mlib.WorldHelper;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public final class GetDifficultyCommand {
    private GetDifficultyCommand() {
    }

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"clampedregionaldifficulty").requires(source -> source.func_197034_c(0))).executes(entity -> GetDifficultyCommand.getCurrentDifficulty((CommandSource)entity.getSource())));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"crd").requires(source -> source.func_197034_c(0))).executes(entity -> GetDifficultyCommand.getCurrentDifficulty((CommandSource)entity.getSource())));
    }

    public static int getCurrentDifficulty(CommandSource source) {
        source.func_197030_a((ITextComponent)GetDifficultyCommand.getFeedbackMessage(source.func_197022_f()), true);
        return 0;
    }

    private static IFormattableTextComponent getFeedbackMessage(Entity entity) {
        TranslationTextComponent feedback = new TranslationTextComponent("commands.regional_difficulty");
        feedback.func_230529_a_((ITextComponent)GetDifficultyCommand.getStateModifierText((LivingEntity)entity));
        return feedback;
    }

    private static IFormattableTextComponent getStateModifierText(@Nullable LivingEntity target) {
        if (target == null) {
            return new StringTextComponent("invalid target").func_240699_a_(TextFormatting.RED);
        }
        StringTextComponent text = new StringTextComponent(" " + String.format("%.2f", WorldHelper.getClampedRegionalDifficulty((Entity)target)));
        StringTextComponent stateText = new StringTextComponent("+ " + GameState.getStateModifier() + " = " + String.format("%.2f", GameState.getRegionalDifficulty(target)));
        switch (GameState.getCurrentMode()) {
            case EXPERT: {
                stateText.func_240701_a_(new TextFormatting[]{GameState.EXPERT_MODE_COLOR, TextFormatting.BOLD});
                text.func_240702_b_(" (");
                text.func_230529_a_((ITextComponent)stateText);
                text.func_240702_b_(")");
                return text;
            }
            case MASTER: {
                stateText.func_240701_a_(new TextFormatting[]{GameState.MASTER_MODE_COLOR, TextFormatting.BOLD});
                text.func_240702_b_(" (");
                text.func_230529_a_((ITextComponent)stateText);
                text.func_240702_b_(")");
                return text;
            }
        }
        return text;
    }
}

