/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.features;

import com.majruszs_difficulty.GameState;
import com.majruszs_difficulty.Instances;
import com.majruszs_difficulty.MajruszsDifficulty;
import com.mlib.config.AvailabilityConfig;
import com.mlib.config.ConfigGroup;
import com.mlib.config.IConfig;
import com.mlib.config.StringListConfig;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class IncreaseGameDifficulty {
    protected final ConfigGroup configGroup = new ConfigGroup("IncreasingDifficulty", "");
    protected final StringListConfig entitiesStartingExpertMode;
    protected final StringListConfig entitiesStartingMasterMode;
    protected final StringListConfig dimensionsStartingExpertMode;
    protected final StringListConfig dimensionsStartingMasterMode;
    protected final AvailabilityConfig enteringAnyDimensionStartsExpertMode;

    public IncreaseGameDifficulty() {
        MajruszsDifficulty.STATE_GROUP.addConfig((IConfig)this.configGroup);
        String entitiesExpertComment = "List of entities starting Expert Mode after killing them.";
        String entitiesMasterComment = "List of entities starting Master Mode after killing them.";
        String dimensionsExpertComment = "List of dimensions starting Expert Mode when a player enters it for the first time. (ignored when any_dimension_expert is set to true)";
        String dimensionsMasterComment = "List of dimensions starting Master Mode when a player enters it for the first time.";
        String anyDimensionComment = "Should entering any dimension start Expert Mode?";
        this.entitiesStartingExpertMode = new StringListConfig("entities_expert", entitiesExpertComment, false, new String[]{"none"});
        this.entitiesStartingMasterMode = new StringListConfig("entities_master", entitiesMasterComment, false, new String[]{"minecraft:ender_dragon"});
        this.dimensionsStartingExpertMode = new StringListConfig("dimensions_expert", dimensionsExpertComment, false, new String[]{"minecraft:the_nether"});
        this.dimensionsStartingMasterMode = new StringListConfig("dimensions_master", dimensionsMasterComment, false, new String[]{"none"});
        this.enteringAnyDimensionStartsExpertMode = new AvailabilityConfig("any_dimension_expert", anyDimensionComment, false, true);
        this.configGroup.addConfigs(new IConfig[]{this.entitiesStartingExpertMode, this.entitiesStartingMasterMode, this.dimensionsStartingExpertMode, this.dimensionsStartingMasterMode, this.enteringAnyDimensionStartsExpertMode});
    }

    @SubscribeEvent
    public static void onChangingDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        IncreaseGameDifficulty gameDifficulty = Instances.INCREASE_GAME_DIFFICULTY;
        PlayerEntity player = event.getPlayer();
        switch (GameState.getCurrentMode()) {
            case NORMAL: {
                gameDifficulty.handleDimensionExpertMode(player, (RegistryKey<World>)event.getTo());
                break;
            }
            case EXPERT: {
                gameDifficulty.handleDimensionMasterMode(player, (RegistryKey<World>)event.getTo());
            }
        }
    }

    @SubscribeEvent
    public static void onKillingEntity(LivingDeathEvent event) {
        IncreaseGameDifficulty gameDifficulty = Instances.INCREASE_GAME_DIFFICULTY;
        LivingEntity entity = event.getEntityLiving();
        switch (GameState.getCurrentMode()) {
            case NORMAL: {
                gameDifficulty.handleKillingEntityExpertMode(entity);
                break;
            }
            case EXPERT: {
                gameDifficulty.handleKillingEntityMasterMode(entity);
            }
        }
    }

    protected void handleDimensionExpertMode(PlayerEntity player, RegistryKey<World> dimension) {
        if (!this.shouldDimensionStartExpertMode(dimension.func_240901_a_())) {
            return;
        }
        this.startExpertMode(player.func_184102_h());
    }

    protected boolean shouldDimensionStartExpertMode(ResourceLocation dimensionLocation) {
        return this.enteringAnyDimensionStartsExpertMode.isEnabled() || this.dimensionsStartingExpertMode.contains(dimensionLocation.toString());
    }

    protected void handleDimensionMasterMode(PlayerEntity player, RegistryKey<World> dimension) {
        if (!this.shouldDimensionStartMasterMode(dimension.func_240901_a_())) {
            return;
        }
        this.startMasterMode(player.func_184102_h());
    }

    protected boolean shouldDimensionStartMasterMode(ResourceLocation dimensionLocation) {
        return this.dimensionsStartingMasterMode.contains(dimensionLocation.toString());
    }

    protected void handleKillingEntityExpertMode(LivingEntity entity) {
        EntityType entityType = entity.func_200600_R();
        if (!this.shouldKillingEntityStartExpertMode(entityType.getRegistryName())) {
            return;
        }
        this.startExpertMode(entity.func_184102_h());
    }

    protected boolean shouldKillingEntityStartExpertMode(@Nullable ResourceLocation entityLocation) {
        return entityLocation != null && this.entitiesStartingExpertMode.contains(entityLocation.toString());
    }

    protected void handleKillingEntityMasterMode(LivingEntity entity) {
        EntityType entityType = entity.func_200600_R();
        if (!this.shouldKillingEntityStartMasterMode(entityType.getRegistryName())) {
            return;
        }
        this.startMasterMode(entity.func_184102_h());
    }

    protected boolean shouldKillingEntityStartMasterMode(@Nullable ResourceLocation entityLocation) {
        return entityLocation != null && this.entitiesStartingMasterMode.contains(entityLocation.toString());
    }

    protected void startExpertMode(@Nullable MinecraftServer minecraftServer) {
        if (minecraftServer == null) {
            return;
        }
        GameState.changeModeWithAdvancement(GameState.State.EXPERT, minecraftServer);
        this.sendMessageToAllPlayers(minecraftServer.func_184103_al(), "majruszs_difficulty.on_expert_mode_start", GameState.EXPERT_MODE_COLOR);
    }

    protected void startMasterMode(@Nullable MinecraftServer minecraftServer) {
        if (minecraftServer == null) {
            return;
        }
        GameState.changeModeWithAdvancement(GameState.State.MASTER, minecraftServer);
        this.sendMessageToAllPlayers(minecraftServer.func_184103_al(), "majruszs_difficulty.on_master_mode_start", GameState.MASTER_MODE_COLOR);
    }

    protected void sendMessageToAllPlayers(PlayerList playerList, String translationKey, TextFormatting textColor) {
        for (PlayerEntity player : playerList.func_181057_v()) {
            TranslationTextComponent message = new TranslationTextComponent(translationKey);
            message.func_240701_a_(new TextFormatting[]{textColor, TextFormatting.BOLD});
            player.func_146105_b((ITextComponent)message, false);
        }
    }
}

