/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.features;

import com.majruszs_difficulty.GameState;
import com.majruszs_difficulty.Instances;
import com.majruszs_difficulty.entities.CreeperlingEntity;
import com.majruszs_difficulty.entities.EliteSkeletonEntity;
import com.majruszs_difficulty.entities.EntitiesConfig;
import com.majruszs_difficulty.entities.GiantEntity;
import com.majruszs_difficulty.entities.PillagerWolfEntity;
import com.majruszs_difficulty.entities.SkyKeeperEntity;
import com.mlib.config.AvailabilityConfig;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.IllusionerEntity;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class SpawnDisabler {
    @SubscribeEvent
    public static void disableSpawns(LivingSpawnEvent.CheckSpawn event) {
        if (SpawnDisabler.shouldEntitySpawnBeDisabled((Entity)event.getEntityLiving())) {
            event.setResult(Event.Result.DENY);
        }
    }

    protected static boolean shouldEntitySpawnBeDisabled(Entity entity) {
        EntitiesConfig config = Instances.ENTITIES_CONFIG;
        boolean isGiant = entity instanceof GiantEntity;
        boolean isIllusioner = entity instanceof IllusionerEntity;
        boolean isPillagerWolf = entity instanceof PillagerWolfEntity;
        boolean isEliteSkeleton = entity instanceof EliteSkeletonEntity;
        boolean isSkyKeeper = entity instanceof SkyKeeperEntity;
        boolean isCreeperling = entity instanceof CreeperlingEntity;
        if (isGiant) {
            return SpawnDisabler.shouldBeDisabled(GameState.State.EXPERT, config.giant.availability);
        }
        if (isIllusioner) {
            return SpawnDisabler.shouldBeDisabled(GameState.State.EXPERT, config.illusioner.availability) || SpawnDisabler.isVillageNearby(entity);
        }
        if (isPillagerWolf) {
            return SpawnDisabler.shouldBeDisabled(GameState.State.EXPERT, config.pillagerWolf.availability);
        }
        if (isEliteSkeleton) {
            return SpawnDisabler.shouldBeDisabled(GameState.State.EXPERT, config.eliteSkeleton.availability);
        }
        if (isSkyKeeper) {
            return SpawnDisabler.shouldBeDisabled(GameState.State.EXPERT, config.skyKeeper.availability);
        }
        if (isCreeperling) {
            return SpawnDisabler.shouldBeDisabled(GameState.State.NORMAL, config.creeperling.availability);
        }
        return false;
    }

    private static boolean shouldBeDisabled(GameState.State minimumState, AvailabilityConfig config) {
        return !GameState.atLeast(minimumState) || config.isDisabled();
    }

    private static boolean isVillageNearby(Entity entity) {
        if (!(entity.field_70170_p instanceof ServerWorld)) {
            return false;
        }
        ServerWorld world = (ServerWorld)entity.field_70170_p;
        return world.func_241117_a_(Structure.field_236381_q_, entity.func_233580_cy_(), 10000, false) != null;
    }
}

