/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.features.monster_spawn;

import com.majruszs_difficulty.GameState;
import com.majruszs_difficulty.features.monster_spawn.OnEnemyToBeSpawnedBase;
import com.mlib.MajruszLibrary;
import com.mlib.config.DurationConfig;
import com.mlib.config.IConfig;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.world.server.ServerWorld;

public class ApplyingNegativeEffectOnCreeperOnSpawn
extends OnEnemyToBeSpawnedBase {
    protected static final Effect[] EFFECTS = new Effect[]{Effects.field_76437_t, Effects.field_76421_d, Effects.field_76419_f, Effects.field_76443_y};
    private static final String CONFIG_NAME = "CreeperEffects";
    private static final String CONFIG_COMMENT = "Creeper spawns with negative effects applied.";
    protected final DurationConfig duration;

    public ApplyingNegativeEffectOnCreeperOnSpawn() {
        super(CONFIG_NAME, CONFIG_COMMENT, 0.375, GameState.State.NORMAL, true);
        String comment = "Duration of effects applied to creeper.";
        this.duration = new DurationConfig("duration", comment, false, 6.0, 1.0, 60.0);
        this.featureGroup.addConfig((IConfig)this.duration);
    }

    @Override
    public void onExecute(LivingEntity entity, ServerWorld world) {
        CreeperEntity creeper = (CreeperEntity)entity;
        Effect randomEffect = EFFECTS[MajruszLibrary.RANDOM.nextInt(EFFECTS.length)];
        creeper.func_195064_c(new EffectInstance(randomEffect, this.duration.getDuration(), 0));
    }

    @Override
    public boolean shouldBeExecuted(LivingEntity entity) {
        return entity instanceof CreeperEntity && super.shouldBeExecuted(entity);
    }
}

