/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.features.monster_spawn;

import com.majruszs_difficulty.GameState;
import com.majruszs_difficulty.features.monster_spawn.SpawnEnemyGroupBase;
import com.mlib.Random;
import com.mlib.config.DoubleConfig;
import com.mlib.config.IConfig;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.piglin.PiglinEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class SpawnPiglinGroup
extends SpawnEnemyGroupBase {
    private static final String CONFIG_NAME = "PiglingGroup";
    private static final String CONFIG_COMMENT = "Piglin spawns in groups.";
    protected final DoubleConfig goldenSwordChance;

    public SpawnPiglinGroup() {
        super(CONFIG_NAME, CONFIG_COMMENT, GameState.State.EXPERT, true, 1, 3, SpawnEnemyGroupBase.Armors.golden);
        String comment = "Chance for followers to have a Golden Sword.";
        this.goldenSwordChance = new DoubleConfig("golden_sword_chance", comment, false, 0.25, 0.0, 0.5);
        this.featureGroup.addConfig((IConfig)this.goldenSwordChance);
    }

    @Override
    public boolean shouldBeExecuted(LivingEntity entity) {
        return entity instanceof PiglinEntity && super.shouldBeExecuted(entity);
    }

    @Override
    protected CreatureEntity spawnChild(ServerWorld world) {
        return (CreatureEntity)EntityType.field_233591_ai_.func_200721_a((World)world);
    }

    @Override
    protected ItemStack generateWeaponForChild() {
        return Random.tryChance((double)this.goldenSwordChance.get()) ? new ItemStack((IItemProvider)Items.field_151010_B) : null;
    }
}

