/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.features.monster_spawn;

import com.majruszs_difficulty.GameState;
import com.majruszs_difficulty.features.monster_spawn.SpawnEnemyGroupBase;
import com.mlib.MajruszLibrary;
import com.mlib.config.DoubleConfig;
import com.mlib.config.IConfig;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.monster.ZombifiedPiglinEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class SpawnZombieGroup
extends SpawnEnemyGroupBase {
    private static final String CONFIG_NAME = "ZombieGroup";
    private static final String CONFIG_COMMENT = "Zombies spawns in groups.";
    protected final DoubleConfig stoneSwordChance;
    protected final DoubleConfig woodenAxeChance;

    public SpawnZombieGroup() {
        super(CONFIG_NAME, CONFIG_COMMENT, GameState.State.EXPERT, true, 1, 3, SpawnEnemyGroupBase.Armors.leather);
        String stone_comment = "Chance for followers to have a Stone Sword.";
        String wooden_comment = "Chance for followers to have a Wooden Axe.";
        this.stoneSwordChance = new DoubleConfig("stone_sword_chance", stone_comment, false, 0.25, 0.0, 0.5);
        this.woodenAxeChance = new DoubleConfig("wooden_axe_chance", wooden_comment, false, 0.25, 0.0, 0.5);
        this.featureGroup.addConfigs(new IConfig[]{this.woodenAxeChance, this.stoneSwordChance});
    }

    @Override
    public boolean shouldBeExecuted(LivingEntity entity) {
        return !(entity instanceof ZombifiedPiglinEntity) && entity instanceof ZombieEntity && super.shouldBeExecuted(entity);
    }

    @Override
    protected CreatureEntity spawnChild(ServerWorld world) {
        return (CreatureEntity)EntityType.field_200725_aD.func_200721_a((World)world);
    }

    @Override
    protected ItemStack generateWeaponForChild() {
        double itemChance = MajruszLibrary.RANDOM.nextDouble();
        if (itemChance <= this.woodenAxeChance.get()) {
            return new ItemStack((IItemProvider)Items.field_151053_p);
        }
        if (itemChance <= this.woodenAxeChance.get() + this.stoneSwordChance.get()) {
            return new ItemStack((IItemProvider)Items.field_151052_q);
        }
        return null;
    }
}

