/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.features.on_death;

import com.majruszs_difficulty.GameState;
import com.majruszs_difficulty.Instances;
import com.majruszs_difficulty.features.on_death.OnDeathBase;
import com.mlib.Random;
import com.mlib.config.DoubleConfig;
import com.mlib.config.IConfig;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.monster.HuskEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.monster.ZombifiedPiglinEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.living.LivingDeathEvent;

public class SpawnPlayerZombieOnDeath
extends OnDeathBase {
    private static final String CONFIG_NAME = "PlayerZombie";
    private static final String CONFIG_COMMENT = "Spawns special Zombie whenever player dies from Bleeding or Zombie.";
    protected final DoubleConfig playerHeadChance;
    protected final DoubleConfig playerHeadDropChance;

    public SpawnPlayerZombieOnDeath() {
        super(CONFIG_NAME, CONFIG_COMMENT, 1.0, GameState.State.EXPERT, false);
        String headComment = "Chance for spawned Zombie to have a player's head.";
        this.playerHeadChance = new DoubleConfig("head_chance", headComment, false, 1.0, 0.0, 1.0);
        String chanceComment = "Chance for special Zombie to drop a player's head on death. (if it has one)";
        this.playerHeadDropChance = new DoubleConfig("head_drop_chance", chanceComment, false, 0.01, 0.0, 1.0);
        this.featureGroup.addConfigs(new IConfig[]{this.playerHeadChance, this.playerHeadDropChance});
    }

    @Override
    public void onExecute(@Nullable LivingEntity attacker, LivingEntity target, LivingDeathEvent event) {
        ServerWorld world = (ServerWorld)target.field_70170_p;
        PlayerEntity player = (PlayerEntity)target;
        EntityType<? extends ZombieEntity> zombieType = this.getZombieType(attacker);
        Entity entity = zombieType.func_220331_a(world, null, null, player.func_233580_cy_(), SpawnReason.EVENT, true, true);
        if (entity == null) {
            return;
        }
        ZombieEntity zombie = (ZombieEntity)entity;
        if (Random.tryChance((double)this.playerHeadChance.get())) {
            ItemStack playerSkull = this.getHead(player);
            zombie.func_184201_a(EquipmentSlotType.HEAD, playerSkull);
            zombie.func_184642_a(EquipmentSlotType.HEAD, (float)this.playerHeadDropChance.get().doubleValue());
        }
        zombie.func_200203_b(player.func_200200_C_());
        zombie.func_98053_h(true);
        zombie.func_110163_bv();
    }

    @Override
    public boolean shouldBeExecuted(@Nullable LivingEntity attacker, LivingEntity target, DamageSource damageSource) {
        boolean hasPlayerDied = target instanceof PlayerEntity;
        boolean hasDiedFromBleeding = damageSource.field_76373_n.equals(Instances.BLEEDING_SOURCE.field_76373_n);
        boolean hasDiedFromZombie = attacker instanceof ZombieEntity;
        return super.shouldBeExecuted(attacker, target, damageSource) && hasPlayerDied && (hasDiedFromZombie || hasDiedFromBleeding);
    }

    private ItemStack getHead(PlayerEntity player) {
        ItemStack playerSkull = new ItemStack((IItemProvider)Items.field_196184_dx, 1);
        CompoundNBT nbt = playerSkull.func_196082_o();
        nbt.func_74778_a("SkullOwner", player.func_195047_I_());
        playerSkull.func_77982_d(nbt);
        return playerSkull;
    }

    private EntityType<? extends ZombieEntity> getZombieType(@Nullable LivingEntity attacker) {
        if (attacker instanceof ZombifiedPiglinEntity) {
            return EntityType.field_233592_ba_;
        }
        if (attacker instanceof HuskEntity) {
            return EntityType.field_200763_C;
        }
        return EntityType.field_200725_aD;
    }
}

