/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.features.special;

import com.majruszs_difficulty.GameState;
import com.majruszs_difficulty.Instances;
import com.majruszs_difficulty.config.GameStateIntegerConfig;
import com.majruszs_difficulty.entities.CreeperlingEntity;
import com.majruszs_difficulty.features.ChanceFeatureBase;
import com.mlib.MajruszLibrary;
import com.mlib.config.IConfig;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class SplitCreeperToCreeperlings
extends ChanceFeatureBase {
    private static final String CONFIG_NAME = "SplitCreeper";
    private static final String CONFIG_COMMENT = "Creepers after the explosion have a chance to spawn Creeperlings.";
    protected final GameStateIntegerConfig creeperlingsAmount;

    public SplitCreeperToCreeperlings() {
        super(CONFIG_NAME, CONFIG_COMMENT, 0.666, GameState.State.NORMAL, false);
        String creeperlingComment = "Maximum amount of Creeperlings.";
        this.creeperlingsAmount = new GameStateIntegerConfig("maximum_creeperlings", creeperlingComment, 1, 3, 5, 0, 10);
        this.featureGroup.addConfig((IConfig)this.creeperlingsAmount);
    }

    @SubscribeEvent
    public static void onExplosion(ExplosionEvent.Detonate event) {
        if (!SplitCreeperToCreeperlings.isValid(event.getExplosion(), event.getWorld())) {
            return;
        }
        SplitCreeperToCreeperlings splitCreeperToCreeperlings = Instances.SPLIT_CREEPER_TO_CREEPERLINGS;
        Explosion explosion = event.getExplosion();
        CreeperEntity creeper = (CreeperEntity)explosion.getExploder();
        ServerWorld world = (ServerWorld)event.getWorld();
        int amountOfCreeperlings = splitCreeperToCreeperlings.getRandomAmountOfCreeperlings();
        if (creeper == null) {
            return;
        }
        for (int i = 0; i < amountOfCreeperlings; ++i) {
            BlockPos position = SplitCreeperToCreeperlings.getNearbyPosition(creeper);
            CreeperlingEntity creeperling = (CreeperlingEntity)CreeperlingEntity.type.func_220342_a(world, null, null, null, position, SpawnReason.SPAWNER, true, true);
            if (creeperling == null) continue;
            creeperling.func_70624_b(creeper.func_70638_az());
        }
    }

    private static BlockPos getNearbyPosition(CreeperEntity creeper) {
        BlockPos position = creeper.func_233580_cy_();
        double x = (double)position.func_177958_n() + MajruszLibrary.RANDOM.nextDouble() - 0.5;
        double y = (double)position.func_177956_o() + MajruszLibrary.RANDOM.nextDouble() - 0.5;
        double z = (double)position.func_177952_p() + MajruszLibrary.RANDOM.nextDouble() - 0.5;
        return new BlockPos(x, y, z);
    }

    private static boolean isValid(Explosion explosion, World world) {
        SplitCreeperToCreeperlings splitCreeperToCreeperlings = Instances.SPLIT_CREEPER_TO_CREEPERLINGS;
        boolean isCausedByCreeper = explosion.getExploder() instanceof CreeperEntity && !(explosion.getExploder() instanceof CreeperlingEntity);
        boolean isServerWorld = world instanceof ServerWorld;
        return isCausedByCreeper && isServerWorld && splitCreeperToCreeperlings.isEnabled() && splitCreeperToCreeperlings.tryChance(null);
    }

    protected int getRandomAmountOfCreeperlings() {
        return MajruszLibrary.RANDOM.nextInt(this.creeperlingsAmount.getCurrentGameStateValue() + 1);
    }
}

