/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.features.treasure_bag;

import com.majruszs_difficulty.Instances;
import com.majruszs_difficulty.MajruszsDifficulty;
import com.majruszs_difficulty.config.GameStateIntegerConfig;
import com.mlib.config.ConfigGroup;
import com.mlib.config.IConfig;
import com.mlib.items.ItemHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class FishingRewarder {
    protected static final String FISHING_TAG = "FishermanTreasureBagCounter";
    protected final ConfigGroup fishingGroup;
    protected final GameStateIntegerConfig treasureBagRequirement;

    public FishingRewarder() {
        String requirementComment = "Required amount of items fished to get Treasure Bag.";
        String groupComment = "Everything related to fishing.";
        this.treasureBagRequirement = new GameStateIntegerConfig("RequiredItems", requirementComment, 20, 15, 10, 3, 100);
        this.fishingGroup = (ConfigGroup)MajruszsDifficulty.FEATURES_GROUP.addGroup((IConfig)new ConfigGroup("Fishing", groupComment));
        this.fishingGroup.addConfig((IConfig)this.treasureBagRequirement);
    }

    @SubscribeEvent
    public static void onFishing(ItemFishedEvent event) {
        PlayerEntity player = event.getPlayer();
        if (!(player.field_70170_p instanceof ServerWorld)) {
            return;
        }
        CompoundNBT data = player.getPersistentData();
        int fishedItemsCounter = data.func_74762_e(FISHING_TAG) + 1;
        data.func_74768_a(FISHING_TAG, fishedItemsCounter);
        if (fishedItemsCounter >= Instances.FISHING_REWARDER.getRequiredItems()) {
            data.func_74768_a(FISHING_TAG, fishedItemsCounter - Instances.FISHING_REWARDER.getRequiredItems());
            if (Instances.FISHING_TREASURE_BAG.isAvailable()) {
                FishingRewarder.giveTreasureBagTo(player);
            }
        }
    }

    protected static void giveTreasureBagTo(PlayerEntity player) {
        ItemHelper.giveItemStackToPlayer((ItemStack)new ItemStack((IItemProvider)Instances.FISHING_TREASURE_BAG), (PlayerEntity)player, (ServerWorld)((ServerWorld)player.field_70170_p));
    }

    protected int getRequiredItems() {
        return this.treasureBagRequirement.getCurrentGameStateValue();
    }
}

