/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.features.treasure_bag;

import com.majruszs_difficulty.items.TreasureBagItem;
import com.mlib.WorldHelper;
import com.mlib.items.ItemHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.server.ServerWorld;

public class TreasureBagManager {
    public static final String TREASURE_BAG_TAG = "TreasureBagPlayersToReward";
    public static final String PLAYER_TAG = "TreasureBagPlayerUUID";
    private static final List<Register> registers = new ArrayList<Register>();

    public static void addTreasureBagTo(EntityType<?> entityType, TreasureBagItem treasureBag, boolean replaceLoot) {
        registers.add(new Register(entityType, treasureBag, replaceLoot));
    }

    public static boolean hasTreasureBag(EntityType<?> entityType) {
        for (Register register : registers) {
            if (!register.entityType.equals(entityType)) continue;
            return true;
        }
        return false;
    }

    public static boolean shouldReplaceLoot(EntityType<?> entityType) {
        for (Register register : registers) {
            if (!register.entityType.equals(entityType)) continue;
            return register.shouldReplaceLoot;
        }
        return false;
    }

    @Nullable
    public static TreasureBagItem getTreasureBag(EntityType<?> entityType) {
        for (Register register : registers) {
            if (!register.entityType.equals(entityType)) continue;
            return register.treasureBag;
        }
        return null;
    }

    public static boolean rewardAllPlayers(LivingEntity killedEntity) {
        CompoundNBT data = killedEntity.getPersistentData();
        ServerWorld world = WorldHelper.getServerWorldFromEntity((Entity)killedEntity);
        if (data.func_74764_b(TREASURE_BAG_TAG) && world != null) {
            ListNBT listNBT = data.func_150295_c(TREASURE_BAG_TAG, 10);
            for (int i = 0; i < listNBT.size(); ++i) {
                CompoundNBT playerNBT = listNBT.func_150305_b(i);
                String playerUUID = playerNBT.func_74779_i(PLAYER_TAG);
                PlayerEntity player = world.func_217371_b(UUID.fromString(playerUUID));
                if (player == null) continue;
                ItemHelper.giveItemStackToPlayer((ItemStack)new ItemStack((IItemProvider)TreasureBagManager.getTreasureBag(killedEntity.func_200600_R())), (PlayerEntity)player, (ServerWorld)world);
            }
            int amountOfPlayersRewarded = listNBT.size();
            listNBT.clear();
            return amountOfPlayersRewarded > 0;
        }
        return false;
    }

    static class Register {
        public final EntityType<?> entityType;
        public final TreasureBagItem treasureBag;
        public final boolean shouldReplaceLoot;

        public Register(EntityType<?> entityType, TreasureBagItem treasureBag, boolean replaceLoot) {
            this.entityType = entityType;
            this.treasureBag = treasureBag;
            this.shouldReplaceLoot = replaceLoot;
        }
    }
}

