/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.features.undead_army;

import com.majruszs_difficulty.Instances;
import com.majruszs_difficulty.RegistryHandler;
import com.majruszs_difficulty.features.undead_army.UndeadArmy;
import com.majruszs_difficulty.features.undead_army.UndeadArmyConfig;
import com.mlib.damage.DamageHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class CountKilledUndead {
    @SubscribeEvent
    public static void onUndeadKill(LivingDeathEvent event) {
        if (!(event.getEntityLiving() instanceof MonsterEntity)) {
            return;
        }
        MonsterEntity monster = (MonsterEntity)event.getEntityLiving();
        if (monster.func_70668_bt() != CreatureAttribute.field_223223_b_) {
            return;
        }
        if (monster.field_70170_p instanceof ServerWorld && RegistryHandler.UNDEAD_ARMY_MANAGER.doesEntityBelongToUndeadArmy((LivingEntity)monster) && CountKilledUndead.updateUndeadArmyKillCounter(monster.func_213303_ch())) {
            return;
        }
        PlayerEntity player = DamageHelper.getPlayerFromDamageSource((DamageSource)event.getSource());
        if (player == null) {
            return;
        }
        CountKilledUndead.increaseKill(player);
        CountKilledUndead.spawnArmyIfPossible(player);
    }

    public static int getKills(PlayerEntity player) {
        return player.getPersistentData().func_74762_e("UndeadKilled");
    }

    protected static void increaseKill(PlayerEntity player) {
        CompoundNBT nbt = player.getPersistentData();
        nbt.func_74768_a("UndeadKilled", CountKilledUndead.getKills(player) + 1);
        player.func_213281_b(nbt);
    }

    private static void spawnArmyIfPossible(PlayerEntity player) {
        CompoundNBT nbt = player.getPersistentData();
        UndeadArmyConfig config = Instances.UNDEAD_ARMY_CONFIG;
        if (nbt.func_74762_e("UndeadKilled") >= config.getRequiredKills() && player.field_70170_p instanceof ServerWorld && RegistryHandler.UNDEAD_ARMY_MANAGER.spawn(player)) {
            nbt.func_74768_a("UndeadKilled", 0);
        }
    }

    private static boolean updateUndeadArmyKillCounter(Vector3d position) {
        UndeadArmy undeadArmy = RegistryHandler.UNDEAD_ARMY_MANAGER.findNearestUndeadArmy(new BlockPos(position));
        if (undeadArmy != null) {
            undeadArmy.increaseUndeadCounter();
            return true;
        }
        return false;
    }
}

