/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.features.undead_army;

import com.majruszs_difficulty.Instances;
import com.majruszs_difficulty.RegistryHandler;
import com.majruszs_difficulty.features.undead_army.Direction;
import com.majruszs_difficulty.features.undead_army.UndeadArmy;
import com.majruszs_difficulty.features.undead_army.UndeadArmyConfig;
import com.mlib.TimeConverter;
import com.mlib.WorldHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class UndeadArmyManager
extends WorldSavedData {
    public static final String DATA_NAME = "undead_army";
    public static final double MAXIMUM_DISTANCE_TO_ARMY = 12000.0;
    private final List<UndeadArmy> undeadArmies = new ArrayList<UndeadArmy>();
    private final List<UndeadArmyToBeSpawned> undeadArmiesToBeSpawned = new ArrayList<UndeadArmyToBeSpawned>();
    private ServerWorld world;
    private long ticksActive = 0L;

    public UndeadArmyManager(ServerWorld world) {
        super(DATA_NAME);
        this.world = world;
    }

    public void func_76184_a(CompoundNBT nbt) {
        this.ticksActive = nbt.func_74763_f("TicksActive");
        ListNBT listNBT = nbt.func_150295_c("Armies", 10);
        for (int i = 0; i < listNBT.size(); ++i) {
            this.undeadArmies.add(new UndeadArmy(this.world, listNBT.func_150305_b(i)));
        }
    }

    public CompoundNBT func_189551_b(CompoundNBT compoundNBT) {
        compoundNBT.func_74772_a("TicksActive", this.ticksActive);
        ListNBT listNBT = new ListNBT();
        for (UndeadArmy undeadArmy : this.undeadArmies) {
            CompoundNBT nbt = new CompoundNBT();
            undeadArmy.write(nbt);
            listNBT.add((Object)nbt);
        }
        compoundNBT.func_218657_a("Armies", (INBT)listNBT);
        return compoundNBT;
    }

    @SubscribeEvent
    public static void onUpdate(TickEvent.ServerTickEvent event) {
        if (event.side.isClient() || event.phase == TickEvent.Phase.END) {
            return;
        }
        RegistryHandler.UNDEAD_ARMY_MANAGER.tick();
    }

    public void updateWorld(ServerWorld world) {
        this.world = world;
        for (UndeadArmy undeadArmy : this.undeadArmies) {
            undeadArmy.updateWorld(world);
        }
    }

    public boolean spawn(PlayerEntity player) {
        BlockPos attackPosition = this.getAttackPosition(player);
        UndeadArmyConfig config = Instances.UNDEAD_ARMY_CONFIG;
        if (this.findNearestUndeadArmy(attackPosition) != null || this.isArmySpawningHere(attackPosition) || config.isUndeadArmyDisabled() || !WorldHelper.isEntityIn((Entity)player, (RegistryKey)World.field_234918_g_)) {
            return false;
        }
        this.undeadArmiesToBeSpawned.add(new UndeadArmyToBeSpawned(TimeConverter.secondsToTicks((double)6.5), attackPosition, Direction.getRandom()));
        this.world.func_184133_a(null, attackPosition, Instances.Sounds.UNDEAD_ARMY_APPROACHING, SoundCategory.AMBIENT, 0.25f, 1.0f);
        return true;
    }

    public void tick() {
        ++this.ticksActive;
        this.tickArmiesToBeSpawned();
        this.tickArmies();
        if (this.ticksActive % 200L == 0L) {
            this.func_76185_a();
        }
    }

    @Nullable
    public UndeadArmy findNearestUndeadArmy(BlockPos position) {
        UndeadArmy nearestArmy = null;
        double minimumDistance = 12000.0;
        for (UndeadArmy undeadArmy : this.undeadArmies) {
            double distanceToUndeadArmy = undeadArmy.getAttackPosition().func_177951_i((Vector3i)position);
            if (!undeadArmy.isActive() || !(distanceToUndeadArmy < minimumDistance)) continue;
            nearestArmy = undeadArmy;
            minimumDistance = distanceToUndeadArmy;
        }
        return nearestArmy;
    }

    public boolean isArmySpawningHere(BlockPos position) {
        for (UndeadArmyToBeSpawned undeadArmyToBeSpawned : this.undeadArmiesToBeSpawned) {
            if (!(undeadArmyToBeSpawned.position.func_177951_i((Vector3i)position) < 12000.0)) continue;
            return true;
        }
        return false;
    }

    public void updateUndeadAIGoals() {
        for (UndeadArmy undeadArmy : this.undeadArmies) {
            undeadArmy.updateNearbyUndeadAIGoals();
        }
    }

    private void tickArmiesToBeSpawned() {
        for (UndeadArmyToBeSpawned undeadArmyToBeSpawned2 : this.undeadArmiesToBeSpawned) {
            --undeadArmyToBeSpawned2.ticksToSpawn;
            if (undeadArmyToBeSpawned2.ticksToSpawn != 0) continue;
            this.undeadArmies.add(new UndeadArmy(this.world, undeadArmyToBeSpawned2.position, undeadArmyToBeSpawned2.direction));
        }
        this.undeadArmiesToBeSpawned.removeIf(undeadArmyToBeSpawned -> undeadArmyToBeSpawned.ticksToSpawn == 0);
    }

    private void tickArmies() {
        for (UndeadArmy undeadArmy2 : this.undeadArmies) {
            undeadArmy2.tick();
        }
        if (this.ticksActive % 20L == 0L) {
            this.undeadArmies.removeIf(undeadArmy -> !undeadArmy.isActive());
        }
    }

    private BlockPos getAttackPosition(PlayerEntity player) {
        Optional bedPosition = player.func_213374_dv();
        BlockPos playerPosition = new BlockPos(player.func_213303_ch());
        BlockPos attackPosition = !bedPosition.isPresent() || playerPosition.func_177951_i((Vector3i)bedPosition.get()) >= 12000.0 ? playerPosition : (BlockPos)bedPosition.get();
        int x = attackPosition.func_177958_n();
        int z = attackPosition.func_177952_p();
        return new BlockPos(x, this.world.func_201676_a(Heightmap.Type.WORLD_SURFACE, x, z), z);
    }

    public boolean doesEntityBelongToUndeadArmy(LivingEntity entity) {
        return UndeadArmy.doesEntityBelongToUndeadArmy(entity);
    }

    public static class UndeadArmyToBeSpawned {
        public int ticksToSpawn;
        public BlockPos position;
        public Direction direction;

        public UndeadArmyToBeSpawned(int ticksToSpawn, BlockPos position, Direction direction) {
            this.ticksToSpawn = ticksToSpawn;
            this.position = position;
            this.direction = direction;
        }
    }
}

