/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.features.when_damaged;

import com.majruszs_difficulty.GameState;
import com.majruszs_difficulty.features.when_damaged.ChanceWhenDamagedBase;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.monster.DrownedEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.TridentItem;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class DrownedLightningOnAttack
extends ChanceWhenDamagedBase {
    private static final String CONFIG_NAME = "DrownedLightning";
    private static final String CONFIG_COMMENT = "Drowned attacks with trident spawn lightning bolt.";

    public DrownedLightningOnAttack() {
        super(CONFIG_NAME, CONFIG_COMMENT, 0.25, GameState.State.EXPERT, true);
    }

    @Override
    public void whenDamaged(@Nullable LivingEntity attacker, LivingEntity target, LivingHurtEvent event) {
        if (!this.tryChance(target)) {
            return;
        }
        ServerWorld world = (ServerWorld)target.func_130014_f_();
        LightningBoltEntity lightningBolt = (LightningBoltEntity)EntityType.field_200728_aG.func_200721_a((World)world);
        if (lightningBolt == null) {
            return;
        }
        lightningBolt.func_225653_b_(target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_());
        world.func_217376_c((Entity)lightningBolt);
    }

    @Override
    public boolean shouldBeExecuted(@Nullable LivingEntity attacker, LivingEntity target, DamageSource damageSource) {
        boolean isDrowned = attacker instanceof DrownedEntity;
        ItemStack heldItemStack = attacker != null ? attacker.func_184614_ca() : null;
        boolean isDrownedHoldingTrident = isDrowned && heldItemStack.func_77973_b() instanceof TridentItem;
        return isDrownedHoldingTrident && super.shouldBeExecuted(attacker, target, damageSource);
    }
}

