/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.features.when_damaged;

import com.majruszs_difficulty.GameState;
import com.majruszs_difficulty.Instances;
import com.majruszs_difficulty.features.when_damaged.ChanceWhenDamagedBase;
import com.mlib.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class EndermanTeleportOnAttack
extends ChanceWhenDamagedBase {
    private static final String CONFIG_NAME = "EndermanTeleport";
    private static final String CONFIG_COMMENT = "Enderman attack teleports the player somewhere nearby.";

    public EndermanTeleportOnAttack() {
        super(CONFIG_NAME, CONFIG_COMMENT, 0.5, GameState.State.MASTER, true);
    }

    @Override
    public void whenDamaged(@Nullable LivingEntity attacker, LivingEntity target, LivingHurtEvent event) {
        if (!this.tryChance(target)) {
            return;
        }
        ServerWorld world = (ServerWorld)target.field_70170_p;
        double distanceFactor = 5.0;
        if (target.field_70167_r + 8.0 > (double)world.func_201676_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, (int)target.field_70169_q, (int)target.field_70166_s)) {
            distanceFactor *= 2.0;
        }
        Vector3d newPosition = Random.getRandomVector3d((double)(-distanceFactor), (double)distanceFactor, (double)-1.0, (double)1.0, (double)(-distanceFactor), (double)distanceFactor).func_178787_e(target.func_213303_ch());
        double y = world.func_201676_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, (int)newPosition.field_72450_a, (int)newPosition.field_72449_c) + 1;
        if (y < 5.0) {
            return;
        }
        world.func_184148_a(null, target.field_70169_q, target.field_70167_r, target.field_70166_s, SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, 1.0f);
        world.func_195598_a((IParticleData)ParticleTypes.field_197599_J, target.field_70169_q, target.func_226283_e_(0.5), target.field_70166_s, 10, 0.25, 0.25, 0.25, 0.1);
        boolean teleportedTarget = target.func_213373_a(newPosition.field_72450_a, target.field_70167_r + 8.0 > y ? y : newPosition.field_72448_b, newPosition.field_72449_c, true);
        if (teleportedTarget && target instanceof ServerPlayerEntity) {
            Instances.SIMPLE_TRIGGER.trigger((ServerPlayerEntity)target, "enderman_teleport_attack");
        }
    }

    @Override
    public boolean shouldBeExecuted(@Nullable LivingEntity attacker, LivingEntity target, DamageSource damageSource) {
        return attacker instanceof EndermanEntity && super.shouldBeExecuted(attacker, target, damageSource);
    }
}

