/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.features.when_damaged;

import com.majruszs_difficulty.GameState;
import com.majruszs_difficulty.features.when_damaged.ChanceWhenDamagedBase;
import com.mlib.config.DurationConfig;
import com.mlib.config.IConfig;
import com.mlib.effects.EffectHelper;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.world.Difficulty;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public abstract class WhenDamagedApplyEffectBase
extends ChanceWhenDamagedBase {
    protected final Effect[] effects;
    protected final DurationConfig effectDuration;

    public WhenDamagedApplyEffectBase(String configName, String configComment, double defaultChance, double defaultDurationInSeconds, GameState.State minimumState, boolean shouldBeMultipliedByCRD, Effect[] effects) {
        super(configName, configComment, defaultChance, minimumState, shouldBeMultipliedByCRD);
        this.effects = effects;
        String comment = "Effect" + (effects.length > 1 ? "s" : "") + " duration in seconds.";
        this.effectDuration = new DurationConfig("duration", comment, false, defaultDurationInSeconds, 1.0, 600.0);
        if (defaultDurationInSeconds != -1.0) {
            this.featureGroup.addConfig((IConfig)this.effectDuration);
        }
    }

    public WhenDamagedApplyEffectBase(String configName, String configComment, double defaultChance, double defaultDurationInSeconds, GameState.State minimumState, boolean shouldBeMultipliedByCRD, Effect effect) {
        this(configName, configComment, defaultChance, defaultDurationInSeconds, minimumState, shouldBeMultipliedByCRD, new Effect[]{effect});
    }

    @Override
    public void whenDamaged(@Nullable LivingEntity attacker, LivingEntity target, LivingHurtEvent event) {
        ServerWorld world = (ServerWorld)target.func_130014_f_();
        Difficulty difficulty = world.func_175659_aa();
        for (Effect effect : this.effects) {
            if (!this.tryChance(target)) continue;
            this.applyEffect(attacker, target, effect, difficulty);
        }
    }

    protected void applyEffect(@Nullable LivingEntity attacker, LivingEntity target, Effect effect, Difficulty difficulty) {
        EffectHelper.applyEffectIfPossible((LivingEntity)target, (Effect)effect, (int)this.getDurationInTicks(difficulty), (int)this.getAmplifier(difficulty));
    }

    protected int getDurationInTicks(Difficulty difficulty) {
        return this.effectDuration.getDuration();
    }

    protected abstract int getAmplifier(Difficulty var1);
}

