/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.generation.structure_pieces;

import com.majruszs_difficulty.Instances;
import com.majruszs_difficulty.MajruszsDifficulty;
import com.majruszs_difficulty.entities.SkyKeeperEntity;
import com.mlib.MajruszLibrary;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.TemplateStructurePiece;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.spawner.AbstractSpawner;

public class FlyingEndShipPiece
extends TemplateStructurePiece {
    public static final List<ResourceLocation> SHIP_RESOURCE_LOCATIONS;
    public static final List<Block> RANDOM_BLOCKS;
    public static final ResourceLocation SHIP_CHEST_RESOURCE_LOCATION;
    public static final ResourceLocation SHIP_EXTRA_CHEST_RESOURCE_LOCATION;
    public static final ResourceLocation SHIP_MILITARY_RESOURCE_LOCATION;
    public static final ResourceLocation SHIP_MILITARY_SMALL_RESOURCE_LOCATION;
    public static final ResourceLocation SHIP_TRADER_RESOURCE_LOCATION;
    private final Rotation rotation;

    public FlyingEndShipPiece(TemplateManager templateManager, BlockPos position, Rotation rotation) {
        super(Instances.FLYING_END_SHIP_PIECE, 0);
        this.field_186178_c = position;
        this.rotation = rotation;
        this.setupPiece(templateManager);
    }

    public FlyingEndShipPiece(TemplateManager templateManager, CompoundNBT compoundNBT) {
        super(Instances.FLYING_END_SHIP_PIECE, compoundNBT);
        this.rotation = Rotation.valueOf((String)compoundNBT.func_74779_i("Rot"));
        this.setupPiece(templateManager);
    }

    protected void func_143011_b(CompoundNBT compoundNBT) {
        super.func_143011_b(compoundNBT);
        compoundNBT.func_74778_a("Rot", this.rotation.name());
    }

    protected void func_186175_a(String function, BlockPos position, IServerWorld world, Random random, MutableBoundingBox boundingBox) {
        if (function.startsWith("chest")) {
            TileEntity tileEntity = world.func_175625_s(position.func_177977_b());
            if (tileEntity instanceof ChestTileEntity) {
                ChestTileEntity chest = (ChestTileEntity)tileEntity;
                chest.func_189404_a(this.getLootTable(function), random.nextLong());
                if (function.startsWith("chest_extra") && com.mlib.Random.tryChance((double)0.75)) {
                    world.func_180501_a(position.func_177977_b(), Blocks.field_150350_a.func_176223_P(), 2);
                }
            }
            world.func_180501_a(position, Blocks.field_150350_a.func_176223_P(), 2);
        } else if (function.startsWith("end_keeper")) {
            world.func_180501_a(position, Blocks.field_150350_a.func_176223_P(), 2);
            SkyKeeperEntity monster = (SkyKeeperEntity)SkyKeeperEntity.type.func_200721_a((World)world.func_201672_e());
            if (monster != null) {
                monster.func_110163_bv();
                monster.func_70107_b(position.func_177958_n(), position.func_177956_o(), position.func_177952_p());
                world.func_217376_c((Entity)monster);
            }
        } else if (function.startsWith("spawner")) {
            world.func_180501_a(position, Blocks.field_150350_a.func_176223_P(), 2);
            world.func_180501_a(position.func_177977_b(), Blocks.field_150474_ac.func_176223_P(), 2);
            TileEntity tileEntity = world.func_175625_s(position.func_177977_b());
            if (tileEntity instanceof MobSpawnerTileEntity) {
                MobSpawnerTileEntity mobSpawnerTileEntity = (MobSpawnerTileEntity)tileEntity;
                AbstractSpawner abstractSpawner = mobSpawnerTileEntity.func_145881_a();
                abstractSpawner.func_200876_a(EntityType.field_200804_r);
            }
        } else if (function.startsWith("random_block")) {
            Block randomBlock = RANDOM_BLOCKS.get(MajruszLibrary.RANDOM.nextInt(RANDOM_BLOCKS.size()));
            world.func_180501_a(position, randomBlock.func_176223_P(), 2);
        }
    }

    public static void start(TemplateManager templateManager, BlockPos position, Rotation rotation, List<StructurePiece> pieces, Random random) {
        BlockPos rotationOffSet = new BlockPos(0, 0, 0).func_190942_a(rotation);
        BlockPos blockpos = rotationOffSet.func_177982_a(position.func_177958_n(), position.func_177956_o(), position.func_177952_p());
        pieces.add((StructurePiece)new FlyingEndShipPiece(templateManager, blockpos, rotation));
    }

    private ResourceLocation getLootTable(String id) {
        switch (id) {
            default: {
                return SHIP_CHEST_RESOURCE_LOCATION;
            }
            case "chest_extra": {
                return SHIP_EXTRA_CHEST_RESOURCE_LOCATION;
            }
            case "chest_military": {
                return SHIP_MILITARY_RESOURCE_LOCATION;
            }
            case "chest_military_small": {
                return SHIP_MILITARY_SMALL_RESOURCE_LOCATION;
            }
            case "chest_trader": 
        }
        return SHIP_TRADER_RESOURCE_LOCATION;
    }

    private void setupPiece(TemplateManager templateManager) {
        Template template = templateManager.func_200220_a(this.getRandomResourceLocation());
        PlacementSettings placementsettings = new PlacementSettings().func_186220_a(this.rotation).func_186214_a(Mirror.NONE);
        this.func_186173_a(template, this.field_186178_c, placementsettings);
    }

    private ResourceLocation getRandomResourceLocation() {
        return SHIP_RESOURCE_LOCATIONS.get(MajruszLibrary.RANDOM.nextInt(SHIP_RESOURCE_LOCATIONS.size()));
    }

    static {
        int i;
        SHIP_RESOURCE_LOCATIONS = new ArrayList<ResourceLocation>();
        RANDOM_BLOCKS = new ArrayList<Block>();
        SHIP_CHEST_RESOURCE_LOCATION = MajruszsDifficulty.getLocation("chests/end_ship");
        SHIP_EXTRA_CHEST_RESOURCE_LOCATION = MajruszsDifficulty.getLocation("chests/end_ship_extra");
        SHIP_MILITARY_RESOURCE_LOCATION = MajruszsDifficulty.getLocation("chests/end_ship_military");
        SHIP_MILITARY_SMALL_RESOURCE_LOCATION = MajruszsDifficulty.getLocation("chests/end_ship_military_small");
        SHIP_TRADER_RESOURCE_LOCATION = MajruszsDifficulty.getLocation("chests/end_ship_trader");
        SHIP_RESOURCE_LOCATIONS.add(MajruszsDifficulty.getLocation("end_island_ship_military"));
        SHIP_RESOURCE_LOCATIONS.add(MajruszsDifficulty.getLocation("end_island_ship_trader"));
        for (i = 0; i < 40; ++i) {
            RANDOM_BLOCKS.add(Blocks.field_150339_S);
        }
        for (i = 0; i < 40; ++i) {
            RANDOM_BLOCKS.add(Blocks.field_150340_R);
        }
        for (i = 0; i < 10; ++i) {
            RANDOM_BLOCKS.add(Blocks.field_150475_bE);
        }
        for (i = 0; i < 5; ++i) {
            RANDOM_BLOCKS.add(Blocks.field_150484_ah);
        }
        for (i = 0; i < 5; ++i) {
            RANDOM_BLOCKS.add(Blocks.field_235398_nh_);
        }
    }
}

